/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;

public class Arrow {
    int al = 18;
    int aw = 10;
    int haw = this.aw / 2;
    int[] xValues = new int[3];
    int[] yValues = new int[3];

    public void drawArrow(Graphics g, int x1, int y1, int x2, int y2) {
        this.calcValues(x1, y1, x2, y2);
        g.drawLine(x1, y1, x2, y2);
        g.fillPolygon(this.xValues, this.yValues, 3);
    }

    public void drawPlusOrMinus(char symbol, Graphics g, int x1, int y1, int x2, int y2, Font myDrawFont) {
        Line lineObj = new Line();
        lineObj.p1 = new Point(x1, y1);
        lineObj.p2 = new Point(x2, y2);
        lineObj.findLineEquation();
        lineObj.findDistance();
        double dist = lineObj.distP1P2;
        dist = dist / 2.0 + dist / 5.0;
        Font font = new Font("Arial", 1, 22);
        g.setFont(font);
        g.setColor(Color.red);
        Point pnt = lineObj.findPoint(dist);
        g.drawString(Character.toString(symbol), pnt.x, pnt.y);
        g.setFont(myDrawFont);
        g.setColor(Color.black);
    }

    public void drawLeavingArc(Graphics g, int x1, int y1, int x2, int y2) {
        this.aw = 28;
        this.haw = 14;
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(new BasicStroke(2.0f));
        g.setColor(Color.red);
        double dist = Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
        this.al = (int)(dist / 2.0) - (int)(dist / 2.0) / 6;
        this.calcValues(x1, y1, x2, y2);
        g.drawLine(this.xValues[1], this.yValues[1], this.xValues[2], this.yValues[2]);
        this.al -= 5;
        this.calcValues(x1, y1, x2, y2);
        g.drawLine(this.xValues[1], this.yValues[1], this.xValues[2], this.yValues[2]);
        g.setColor(Color.black);
        this.al = 21;
        this.aw = 8;
        this.haw = this.aw / 2;
        g2.setStroke(new BasicStroke(1.0f));
    }

    public void drawOnlyArrow(Graphics g, int x1, int y1, int x2, int y2) {
        this.calcValues(x1, y1, x2, y2);
        g.fillPolygon(this.xValues, this.yValues, 3);
    }

    public void drawTreeArrow(Graphics g, int x1, int y1, int x2, int y2) {
        this.al = 15;
        this.aw = 8;
        this.haw = 4;
        this.calcValues(x1, y1, x2, y2);
        g.drawLine(x1, y1, x2, y2);
        g.fillPolygon(this.xValues, this.yValues, 3);
        this.al = 21;
        this.aw = 8;
        this.haw = this.aw / 2;
    }

    public void calcValues(int x1, int y1, int x2, int y2) {
        if (x1 == x2) {
            if (y2 < y1) {
                this.arrowCoords(x2, y2, x2 - this.haw, y2 + this.al, x2 + this.haw, y2 + this.al);
            } else {
                this.arrowCoords(x2, y2, x2 - this.haw, y2 - this.al, x2 + this.haw, y2 - this.al);
            }
            return;
        }
        if (y1 == y2) {
            if (x2 > x1) {
                this.arrowCoords(x2, y2, x2 - this.al, y2 - this.haw, x2 - this.al, y2 + this.haw);
            } else {
                this.arrowCoords(x2, y2, x2 + this.al, y2 - this.haw, x2 + this.al, y2 + this.haw);
            }
            return;
        }
        this.calcValuesQuad(x1, y1, x2, y2);
    }

    public void calcValuesQuad(int x1, int y1, int x2, int y2) {
        double arrowAng = Math.toDegrees(Math.atan((double)this.haw / (double)this.al));
        double dist = Math.sqrt(this.al * this.al + this.aw);
        double lineAng = Math.toDegrees(Math.atan((double)Math.abs(x1 - x2) / (double)Math.abs(y1 - y2)));
        if (x1 > x2) {
            if (y1 > y2) {
                lineAng = 180.0 - lineAng;
            }
        } else {
            lineAng = y1 > y2 ? 180.0 + lineAng : 360.0 - lineAng;
        }
        this.xValues[0] = x2;
        this.yValues[0] = y2;
        this.calcCoords(1, x2, y2, dist, lineAng - arrowAng);
        this.calcCoords(2, x2, y2, dist, lineAng + arrowAng);
    }

    public void calcCoords(int index, int x, int y, double dist, double dirn) {
        while (dirn < 0.0) {
            dirn = 360.0 + dirn;
        }
        while (dirn > 360.0) {
            dirn -= 360.0;
        }
        if (dirn <= 90.0) {
            this.xValues[index] = x + (int)(Math.sin(Math.toRadians(dirn)) * dist);
            this.yValues[index] = y - (int)(Math.cos(Math.toRadians(dirn)) * dist);
            return;
        }
        if (dirn <= 180.0) {
            this.xValues[index] = x + (int)(Math.cos(Math.toRadians(dirn - 90.0)) * dist);
            this.yValues[index] = y + (int)(Math.sin(Math.toRadians(dirn - 90.0)) * dist);
            return;
        }
        if (dirn <= 90.0) {
            this.xValues[index] = x - (int)(Math.sin(Math.toRadians(dirn - 180.0)) * dist);
            this.yValues[index] = y + (int)(Math.cos(Math.toRadians(dirn - 180.0)) * dist);
        } else {
            this.xValues[index] = x - (int)(Math.cos(Math.toRadians(dirn - 270.0)) * dist);
            this.yValues[index] = y - (int)(Math.sin(Math.toRadians(dirn - 270.0)) * dist);
        }
    }

    public void arrowCoords(int x1, int y1, int x2, int y2, int x3, int y3) {
        this.xValues[0] = x1;
        this.yValues[0] = y1;
        this.xValues[1] = x2;
        this.yValues[1] = y2;
        this.xValues[2] = x3;
        this.yValues[2] = y3;
    }
}

