/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Label;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.TextArea;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;

public class BigMGraph {
    int depth;
    int[] x;
    int[] p;
    int[] t;
    int[] d;
    int[] y;
    int[] z;
    Set zSet;
    LinkedList TList;
    LinkedList TstarList;
    LinkedList tStarArcs;
    LinkedList TstarListCopy;
    LinkedList[] Yi;
    int[] Vi;
    LinkedList[] LYi;
    int[] Xi;
    LinkedList[] RYi;
    int[] Ui;
    int J;
    int V;
    int B;
    Utils utilsObj = new Utils();
    Arrow arrowObj = new Arrow();
    DisplayUtils displayUtilsObj = new DisplayUtils();
    public static final int MAXNODES = 16;
    public static final int MAXARCS = 43;
    int[][] Adjacency = new int[16][16];
    int[][] nodeArcMatrix = new int[16][43];
    boolean[] wasVisited = new boolean[16];
    int currentNodes = 0;
    int currentArcs = 0;
    int[] CoordinateX = new int[16];
    int[] CoordinateY = new int[16];
    int[] CenterX = new int[16];
    int[] CenterY = new int[16];
    int[] nodeSupplies = new int[16];
    int[] inDegree = new int[16];
    int[] Wij = new int[16];
    int[] arcOrder;
    int[] arcStartXCoordinate;
    int[] arcStartYCoordinate;
    int[] arcEndXCoordinate;
    int[] arcEndYCoordinate;
    int[] arcCenterXCoordinate;
    int[] arcCenterYCoordinate;
    int[] arcCosts;
    int[] arcStartNode;
    int[] arcTargetNode;
    int[] Xij;
    int[] Sij;
    int[] previousCenterX = new int[16];
    int[] previousCenterY = new int[16];
    int[] previousArcStartXCoordinate = new int[43];
    int[] previousArcStartYCoordinate = new int[43];
    int[] previousArcEndXCoordinate = new int[43];
    int[] previousArcEndYCoordinate = new int[43];
    int[] previousArcCenterXCoordinate = new int[43];
    int[] previousArcCenterYCoordinate = new int[43];

    public BigMGraph() {
        this.arcStartNode = new int[43];
        this.arcTargetNode = new int[43];
        this.arcOrder = new int[43];
        this.arcStartXCoordinate = new int[43];
        this.arcStartYCoordinate = new int[43];
        this.arcEndXCoordinate = new int[43];
        this.arcEndYCoordinate = new int[43];
        this.arcCenterXCoordinate = new int[43];
        this.arcCenterYCoordinate = new int[43];
        this.arcCosts = new int[43];
        this.Xij = new int[43];
        this.Sij = new int[43];
    }

    public void fillBigMGraph(int currentNodes, int currentArcs, int[][] Adjacency, int[][] nodeArcMatrix, int[] CoordinateX, int[] CoordinateY, int[] CenterX, int[] CenterY, int[] nodeSupplies, int[] inDegree, int[] arcStartNode, int[] arcTargetNode, int[] arcOrder, int[] arcStartXCoordinate, int[] arcStartYCoordinate, int[] arcEndXCoordinate, int[] arcEndYCoordinate, int[] arcCenterXCoordinate, int[] arcCenterYCoordinate, int[] arcCosts) {
        this.currentNodes = currentNodes;
        this.currentArcs = currentArcs;
        this.utilsObj.copyAdjacency(Adjacency, currentNodes, this.Adjacency);
        this.utilsObj.copyNodeArc(nodeArcMatrix, currentNodes, currentArcs, this.nodeArcMatrix);
        System.arraycopy(CoordinateX, 0, this.CoordinateX, 0, currentNodes);
        System.arraycopy(CoordinateY, 0, this.CoordinateY, 0, currentNodes);
        System.arraycopy(CenterX, 0, this.CenterX, 0, currentNodes);
        System.arraycopy(CenterY, 0, this.CenterY, 0, currentNodes);
        System.arraycopy(nodeSupplies, 0, this.nodeSupplies, 0, currentNodes);
        System.arraycopy(inDegree, 0, this.inDegree, 0, currentNodes);
        System.arraycopy(arcStartNode, 0, this.arcStartNode, 0, currentArcs);
        System.arraycopy(arcTargetNode, 0, this.arcTargetNode, 0, currentArcs);
        System.arraycopy(arcOrder, 0, this.arcOrder, 0, currentArcs);
        System.arraycopy(arcStartXCoordinate, 0, this.arcStartXCoordinate, 0, currentArcs);
        System.arraycopy(arcStartYCoordinate, 0, this.arcStartYCoordinate, 0, currentArcs);
        System.arraycopy(arcEndXCoordinate, 0, this.arcEndXCoordinate, 0, currentArcs);
        System.arraycopy(arcEndYCoordinate, 0, this.arcEndYCoordinate, 0, currentArcs);
        System.arraycopy(arcCenterXCoordinate, 0, this.arcCenterXCoordinate, 0, currentArcs);
        System.arraycopy(arcCenterYCoordinate, 0, this.arcCenterYCoordinate, 0, currentArcs);
        System.arraycopy(arcCosts, 0, this.arcCosts, 0, currentArcs);
    }

    public void addNode(int artNodeTopLeftX, int artNodeTopLeftY, int nodeDiameter) {
        this.CenterX[this.currentNodes] = artNodeTopLeftX + nodeDiameter / 2;
        this.CenterY[this.currentNodes] = artNodeTopLeftY + nodeDiameter / 2;
        this.CoordinateX[this.currentNodes] = artNodeTopLeftX;
        this.CoordinateY[this.currentNodes] = artNodeTopLeftY;
        this.nodeSupplies[this.currentNodes] = 0;
        this.inDegree[this.currentNodes] = 0;
        ++this.currentNodes;
    }

    public void addArc(int startNode, int targetNode, int cost, int myNodeDiameter) {
        Point p1 = new Point(this.CenterX[startNode], this.CenterY[startNode]);
        Point p2 = new Point(this.CenterX[targetNode], this.CenterY[targetNode]);
        Point p3 = new Point(0, 0);
        Point p4 = new Point(0, 0);
        this.utilsObj.calculateIntersectPoints(p1, p2, p3, p4, myNodeDiameter);
        int xArcCenter = (int)(p3.getX() + p4.getX()) / 2;
        int yArcCenter = (int)(p3.getY() + p4.getY()) / 2;
        this.Adjacency[startNode][targetNode] = 1;
        int n = targetNode;
        this.inDegree[n] = this.inDegree[n] + 1;
        this.nodeArcMatrix[startNode][this.currentArcs] = 1;
        this.nodeArcMatrix[targetNode][this.currentArcs] = -1;
        this.arcStartXCoordinate[this.currentArcs] = (int)p3.getX();
        this.arcStartYCoordinate[this.currentArcs] = (int)p3.getY();
        this.arcEndXCoordinate[this.currentArcs] = (int)p4.getX();
        this.arcEndYCoordinate[this.currentArcs] = (int)p4.getY();
        this.arcCenterXCoordinate[this.currentArcs] = xArcCenter;
        this.arcCenterYCoordinate[this.currentArcs] = yArcCenter;
        this.arcStartNode[this.currentArcs] = startNode;
        this.arcTargetNode[this.currentArcs] = targetNode;
        this.arcCosts[this.currentArcs] = cost;
        ++this.currentArcs;
        this.utilsObj.sortArcsAccordingToAdjacency(this.currentNodes, this.currentArcs - 1, this.Adjacency, this.arcOrder, this.arcStartNode, this.arcTargetNode);
    }

    public void computeXijWijSij(int M) {
        int i;
        for (i = 0; i < this.currentArcs; ++i) {
            if (this.arcTargetNode[i] == this.currentNodes - 1) {
                this.Xij[i] = this.nodeSupplies[this.arcStartNode[i]];
            }
            if (this.arcStartNode[i] != this.currentNodes - 1) continue;
            this.Xij[i] = -this.nodeSupplies[this.arcTargetNode[i]];
        }
        for (i = 0; i < this.currentNodes - 1; ++i) {
            this.Wij[i] = this.nodeSupplies[i] > 0 ? M : -M;
        }
        HashSet Ns = new HashSet();
        HashSet Nd = new HashSet();
        this.utilsObj.createSetsNsAndNd(this.nodeSupplies, this.currentNodes - 1, Ns, Nd);
        for (int i2 = 0; i2 < this.currentArcs; ++i2) {
            if (Ns.contains(new Integer(this.arcStartNode[i2])) & Nd.contains(new Integer(this.arcTargetNode[i2]))) {
                this.Sij[i2] = -2 * M + this.arcCosts[i2];
            }
            if (Nd.contains(new Integer(this.arcStartNode[i2])) & Ns.contains(new Integer(this.arcTargetNode[i2]))) {
                this.Sij[i2] = 2 * M + this.arcCosts[i2];
            }
            if (Ns.contains(new Integer(this.arcStartNode[i2])) & Ns.contains(new Integer(this.arcTargetNode[i2]))) {
                this.Sij[i2] = this.arcCosts[i2];
            }
            if (!(Nd.contains(new Integer(this.arcStartNode[i2])) & Nd.contains(new Integer(this.arcTargetNode[i2])))) continue;
            this.Sij[i2] = this.arcCosts[i2];
        }
    }

    public void createBasicAndNonBasicArcSets(Set Basic, Set NonBasic) {
        int i;
        HashSet<Integer> allArcs = new HashSet<Integer>();
        for (i = 0; i < this.currentArcs; ++i) {
            allArcs.add(new Integer(i));
        }
        for (i = 0; i < this.currentArcs; ++i) {
            if (!(this.arcStartNode[i] == this.currentNodes - 1 | this.arcTargetNode[i] == this.currentNodes - 1)) continue;
            Basic.add(new Integer(i));
        }
        allArcs.removeAll(Basic);
        NonBasic.addAll(allArcs);
    }

    public void displayBigMGraph() {
        int i;
        for (i = 0; i < this.currentNodes; ++i) {
            for (int j = 0; j < this.currentNodes; ++j) {
                System.out.print(this.Adjacency[i][j] + " ");
            }
            System.out.println();
        }
        System.out.println("Node-Supplies");
        for (i = 0; i < this.currentNodes; ++i) {
            System.out.println(this.nodeSupplies[i]);
        }
        System.out.println("Arcs");
        for (i = 0; i < this.currentArcs; ++i) {
            System.out.println("Arc : " + i + " " + (this.arcStartNode[i] + 1) + "-" + (this.arcTargetNode[i] + 1) + " Cost = " + this.arcCosts[i] + " " + " Order = " + this.arcOrder[i]);
        }
    }

    public void displayBigMGraph(Graphics g, int myNodeDiameter, FontMetrics myFontMetrics, Label message, Set Basic, Set NonBasic) {
        int i;
        Graphics2D g2d = (Graphics2D)g;
        BasicStroke dashedStroke = new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{5.0f, 7.0f}, 0.0f);
        BasicStroke solidStroke = new BasicStroke();
        Color lightSlateGray = new Color(153, 153, 255);
        for (i = 0; i < this.currentNodes; ++i) {
            g2d.setColor(lightSlateGray);
            g2d.fillOval(this.CoordinateX[i], this.CoordinateY[i], myNodeDiameter, myNodeDiameter);
            if (i == this.currentNodes - 1) {
                g2d.drawOval(this.CoordinateX[i] - 5, this.CoordinateY[i] - 5, myNodeDiameter + 10, myNodeDiameter + 10);
            }
            g2d.setColor(Color.BLACK);
            int h = myFontMetrics.getHeight();
            int w = myFontMetrics.stringWidth(String.valueOf(i + 1));
            g2d.drawString(Integer.toString(i + 1), this.CenterX[i] - w / 2, this.CenterY[i] + h / 4);
        }
        for (i = 0; i < this.currentArcs; ++i) {
            if (Basic.contains(new Integer(i))) {
                g2d.setStroke(solidStroke);
            }
            if (NonBasic.contains(new Integer(i))) {
                g2d.setStroke(dashedStroke);
            }
            this.arrowObj.drawArrow(g2d, this.arcStartXCoordinate[i], this.arcStartYCoordinate[i], this.arcEndXCoordinate[i], this.arcEndYCoordinate[i]);
        }
        for (i = 0; i <= this.currentNodes - 1; ++i) {
            g2d.setColor(Color.blue);
            g2d.drawString(String.valueOf(this.Wij[i]), this.CoordinateX[i] - 4, this.CoordinateY[i] - 4);
        }
        g2d.setColor(Color.red);
        for (i = 0; i <= this.currentArcs - 1; ++i) {
            if (!(this.arcStartNode[i] == this.currentNodes - 1 | this.arcTargetNode[i] == this.currentNodes - 1)) continue;
            g2d.drawString(String.valueOf(this.Xij[i]), this.arcCenterXCoordinate[i], this.arcCenterYCoordinate[i]);
        }
        for (i = 0; i <= this.currentArcs - 1; ++i) {
            if (!(this.arcStartNode[i] != this.currentNodes - 1 & this.arcTargetNode[i] != this.currentNodes - 1)) continue;
            if (!this.utilsObj.existOppositeArc(this.arcStartNode[i], this.arcTargetNode[i], this.Adjacency, this.currentNodes)) {
                g2d.drawString(String.valueOf(this.Sij[i]), this.arcCenterXCoordinate[i], this.arcCenterYCoordinate[i]);
                continue;
            }
            g2d.drawString(String.valueOf(this.Sij[i]), (this.arcCenterXCoordinate[i] + this.arcEndXCoordinate[i]) / 2, (this.arcCenterYCoordinate[i] + this.arcEndYCoordinate[i]) / 2);
        }
        if (this.currentNodes > 0) {
            message.setText("THE GRAPH HAS " + Integer.toString(this.currentNodes) + " NODES" + " AND " + Integer.toString(this.currentArcs) + " ARCS/EDGES" + "    >> MAXIMUM (N,A)=(" + 16 + "," + 43 + ") <<");
        }
    }

    public void createBigMTree(Set BasicArcs) {
        int i;
        int i2;
        this.depth = 0;
        this.x = new int[16];
        this.p = new int[16];
        this.t = new int[16];
        this.d = new int[16];
        this.y = new int[16];
        this.depth = 1;
        this.x[this.currentNodes - 1] = 0;
        Object[] basicArcsObj = BasicArcs.toArray();
        int arc = -1;
        for (i2 = 0; i2 < basicArcsObj.length; ++i2) {
            arc = (Integer)basicArcsObj[i2];
            if (this.arcStartNode[arc] == this.currentNodes - 1) {
                this.x[this.arcTargetNode[arc]] = this.Xij[arc];
            }
            if (this.arcTargetNode[arc] != this.currentNodes - 1) continue;
            this.x[this.arcStartNode[arc]] = this.Xij[arc];
        }
        this.p[this.currentNodes - 1] = -1;
        for (i2 = 0; i2 <= this.currentNodes - 2; ++i2) {
            this.p[i2] = this.currentNodes - 1;
        }
        this.t[this.currentNodes - 1] = -1;
        Iterator itr = BasicArcs.iterator();
        Integer arcObj = null;
        arc = -1;
        while (itr.hasNext()) {
            arcObj = (Integer)itr.next();
            arc = arcObj;
            if (this.arcStartNode[arc] == this.currentNodes - 1) {
                this.t[this.arcTargetNode[arc]] = 0;
            }
            if (this.arcTargetNode[arc] != this.currentNodes - 1) continue;
            this.t[this.arcStartNode[arc]] = 1;
        }
        this.d[this.currentNodes - 1] = 0;
        for (i = 0; i < this.currentNodes - 1; ++i) {
            this.d[i] = 1;
        }
        this.y[this.currentNodes - 1] = 0;
        for (i = 0; i <= this.currentNodes - 3; ++i) {
            this.y[i] = i + 1;
        }
        this.y[this.currentNodes - 2] = this.currentNodes - 1;
    }

    public void createPreorderFromY(TextArea algorithmTextArea) {
        this.TList = new LinkedList();
        int node = 0;
        int root = this.currentNodes - 1;
        this.TList.add(new Integer(root));
        node = root;
        while (this.y[node] != root) {
            node = this.y[node];
            this.TList.add(new Integer(node));
        }
        algorithmTextArea.append("--------------------\n");
        algorithmTextArea.append("Tree Preorder : " + this.utilsObj.incrementListBy1(this.TList) + "\n");
    }

    public void displayBigMTree() {
        int i;
        System.out.println("p==");
        for (i = 0; i < this.currentNodes; ++i) {
            System.out.println(this.p[i]);
        }
        System.out.println("t==");
        for (i = 0; i < this.currentNodes; ++i) {
            System.out.println(this.t[i]);
        }
        System.out.println("d==");
        for (i = 0; i < this.currentNodes; ++i) {
            System.out.println(this.d[i]);
        }
        System.out.println("y==");
        for (i = 0; i < this.currentNodes; ++i) {
            System.out.println(this.y[i]);
        }
        System.out.println("x==");
        for (i = 0; i < this.currentNodes; ++i) {
            System.out.println(this.x[i]);
        }
        System.out.println("w==");
        for (i = 0; i < this.currentNodes; ++i) {
            System.out.println(this.Wij[i]);
        }
        System.out.println("Xij==");
        for (i = 0; i < this.currentArcs; ++i) {
            System.out.println(this.Xij[i]);
        }
        System.out.println("Sij==");
        for (i = 0; i < this.currentArcs; ++i) {
            System.out.println(this.Sij[i]);
        }
        System.out.println("ARCS==");
        for (i = 0; i < this.currentArcs; ++i) {
            System.out.println(this.arcStartNode[i] + " " + this.arcTargetNode[i]);
        }
    }

    public void calculateNodeCoords(int panelWidth, int panelHeight) {
        int netPanelWidth = 0;
        int netPanelHeight = 0;
        int nodeDiameter = 20;
        int topMargin = 40;
        int bottomMargin = 40;
        int leftMargin = 40;
        int rightMargin = 40;
        int xOffset = 0;
        int yOffset = 0;
        netPanelWidth = panelWidth - leftMargin - rightMargin - 2;
        netPanelHeight = panelHeight - topMargin - bottomMargin - 2;
        if (this.depth == 1) {
            yOffset = (netPanelHeight - nodeDiameter) / 2;
        }
        if (this.depth >= 2) {
            yOffset = (netPanelHeight - nodeDiameter) / (this.depth + 1);
        }
        int xCenter = (netPanelWidth - nodeDiameter) / 2 + leftMargin;
        int yCenter = topMargin + nodeDiameter / 2;
        int currentNode = 0;
        this.CenterX[this.currentNodes - 1] = xCenter;
        this.CenterY[this.currentNodes - 1] = yCenter;
        Queue queue = new Queue(this.currentNodes);
        queue.insert(this.currentNodes - 1);
        int nodesBelow = 0;
        LinkedList childsBelowInPreorder = new LinkedList();
        int node = 0;
        int d = 0;
        while (!queue.isEmpty()) {
            currentNode = queue.remove();
            if (this.d[currentNode] >= d) {
                System.out.println(this.d[currentNode]);
                ++d;
                nodesBelow = this.utilsObj.numOfNodesOneLevelBelow(currentNode, this.currentNodes, this.d);
                System.out.println(nodesBelow);
                if (nodesBelow > 0) {
                    yCenter += yOffset;
                    xOffset = (netPanelWidth - nodeDiameter) / nodesBelow;
                    xCenter = xOffset / 2 + leftMargin;
                }
            }
            childsBelowInPreorder = this.utilsObj.findChildsInPreorder(this.TList, currentNode, this.p);
            System.out.println(childsBelowInPreorder);
            Iterator it = childsBelowInPreorder.iterator();
            while (it.hasNext()) {
                node = (Integer)it.next();
                this.CenterX[node] = xCenter;
                this.CenterY[node] = yCenter;
                queue.insert(node);
                xCenter += xOffset;
            }
        }
    }

    public void calculateArcCoords() {
        int startNode = -1;
        int targetNode = -1;
        Point p1 = null;
        Point p2 = null;
        Point p3 = null;
        Point p4 = null;
        int nodeDiameter = 20;
        for (int i = 0; i < this.currentArcs; ++i) {
            startNode = this.arcStartNode[i];
            targetNode = this.arcTargetNode[i];
            p1 = new Point(this.CenterX[startNode], this.CenterY[startNode]);
            p2 = new Point(this.CenterX[targetNode], this.CenterY[targetNode]);
            p3 = new Point();
            p4 = new Point();
            this.utilsObj.calculateIntersectPoints(p1, p2, p3, p4, nodeDiameter);
            this.arcStartXCoordinate[i] = (int)p3.getX();
            this.arcStartYCoordinate[i] = (int)p3.getY();
            this.arcEndXCoordinate[i] = (int)p4.getX();
            this.arcEndYCoordinate[i] = (int)p4.getY();
            this.arcCenterXCoordinate[i] = (int)(p3.getX() + p4.getX()) / 2;
            this.arcCenterYCoordinate[i] = (int)(p3.getY() + p4.getY()) / 2;
        }
    }

    public void displayBigMTree(Graphics g, Set BasicArcs, Set NonBasicArcs, FontMetrics myFontMetrics) {
        int i;
        int w = 0;
        Color lightSlateGray = new Color(153, 153, 255);
        g.setColor(lightSlateGray);
        for (i = 0; i < this.currentNodes; ++i) {
            g.fillOval(this.CenterX[i] - 10, this.CenterY[i] - 10, 20, 20);
        }
        g.setColor(Color.black);
        for (i = 0; i <= this.currentArcs; ++i) {
            if (!BasicArcs.contains(new Integer(i))) continue;
            g.setColor(Color.BLACK);
            this.arrowObj.drawTreeArrow(g, this.arcStartXCoordinate[i], this.arcStartYCoordinate[i], this.arcEndXCoordinate[i], this.arcEndYCoordinate[i]);
        }
        int h = myFontMetrics.getHeight();
        for (int i2 = 0; i2 < this.currentNodes; ++i2) {
            g.setColor(Color.BLACK);
            w = myFontMetrics.stringWidth(String.valueOf(i2 + 1));
            g.drawString(Integer.toString(i2 + 1), this.CenterX[i2] - w / 2, this.CenterY[i2] + h / 4);
        }
        boolean WijWidth = false;
        for (int i3 = 0; i3 <= this.currentNodes - 1; ++i3) {
            g.setColor(Color.white);
            g.fillRect(this.CenterX[i3] - 14 - 2, this.CenterY[i3] - 20 - h, myFontMetrics.stringWidth(String.valueOf(this.Wij[i3])) + 2, h + 2);
            g.setColor(Color.blue);
            g.drawString(String.valueOf(this.Wij[i3]), this.CenterX[i3] - 14, this.CenterY[i3] - 20);
        }
        int x = 0;
        int y = 0;
        for (int i4 = 0; i4 < this.currentArcs; ++i4) {
            if (!BasicArcs.contains(new Integer(i4))) continue;
            x = this.arcCenterXCoordinate[i4];
            y = this.arcCenterYCoordinate[i4];
            w = myFontMetrics.stringWidth(String.valueOf(this.Xij[i4]));
            g.setColor(Color.white);
            g.fillRect(x - w / 2 - 2, y - h, w + 4, h + 3);
            g.setColor(Color.red);
            g.drawString(String.valueOf(this.Xij[i4]), x - w / 2, y);
        }
    }

    public void displayTstarAndPivotStem(Graphics2D g2, FontMetrics myFontMetrics, Color nodeColor, Color labelColor, Color stemColor) {
        Iterator it = this.TstarList.iterator();
        int node = -1;
        int w = -1;
        int h = -1;
        while (it.hasNext()) {
            node = (Integer)it.next();
            g2.setColor(nodeColor);
            g2.fillOval(this.CenterX[node] - 10, this.CenterY[node] - 10, 20, 20);
            g2.setColor(labelColor);
            h = myFontMetrics.getHeight();
            w = myFontMetrics.stringWidth(String.valueOf(node + 1));
            g2.drawString(Integer.toString(node + 1), this.CenterX[node] - w / 2, this.CenterY[node] + h / 4);
        }
        g2.setStroke(new BasicStroke(2.0f));
        g2.setColor(stemColor);
        for (int i = 0; i < this.z.length; ++i) {
            g2.drawOval(this.CenterX[this.z[i]] - 10, this.CenterY[this.z[i]] - 10, 20, 20);
        }
        g2.setStroke(new BasicStroke());
    }

    public void displayTstarAndPivotStem(Graphics g, FontMetrics myFontMetrics, Color color) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Iterator it = this.TstarList.iterator();
        int node = -1;
        int w = -1;
        int h = -1;
        while (it.hasNext()) {
            node = (Integer)it.next();
            g2.setColor(Color.red);
            g2.fillOval(this.CenterX[node] - 10, this.CenterY[node] - 10, 20, 20);
            g2.setColor(Color.white);
            h = myFontMetrics.getHeight();
            w = myFontMetrics.stringWidth(String.valueOf(node + 1));
            g2.drawString(Integer.toString(node + 1), this.CenterX[node] - w / 2, this.CenterY[node] + h / 4);
        }
        g2.setStroke(new BasicStroke(2.0f));
        g2.setColor(Color.blue);
        for (int i = 0; i < this.z.length; ++i) {
            g2.drawOval(this.CenterX[this.z[i]] - 10, this.CenterY[this.z[i]] - 10, 20, 20);
        }
        g2.setStroke(new BasicStroke(1.0f));
    }

    public void createPivotStem(int e1, int f1, TextArea algorithmTextArea) {
        int u = this.d[e1] - this.d[f1] + 1;
        this.z = new int[u];
        int k = 0;
        this.z[k] = e1;
        int nodeptr = e1;
        while (nodeptr != f1) {
            nodeptr = this.p[nodeptr];
            this.z[++k] = nodeptr;
        }
        this.zSet = new LinkedHashSet();
        LinkedHashSet<Integer> zSetDisplay = new LinkedHashSet<Integer>();
        for (int i = 0; i < u; ++i) {
            this.zSet.add(new Integer(this.z[i]));
            zSetDisplay.add(new Integer(this.z[i] + 1));
        }
        algorithmTextArea.append("--------------------\n");
        algorithmTextArea.append("PIVOT STEM :" + zSetDisplay + "\n");
        algorithmTextArea.append("--------------------\n");
    }

    public void updateXi(int e, LinkedList CPlus, LinkedList CMinus, TextArea algorithmtextArea) {
        int i;
        HashSet C = new HashSet();
        HashSet<Integer> CDisplay = new HashSet<Integer>();
        C.addAll(CPlus);
        C.addAll(CMinus);
        Iterator itr = C.iterator();
        int node = -1;
        while (itr.hasNext()) {
            node = (Integer)itr.next();
            CDisplay.add(new Integer(node + 1));
        }
        algorithmtextArea.append("Cycle: " + CDisplay + "\n");
        algorithmtextArea.append("--------------------\n");
        algorithmtextArea.append("UPDATE X(i) for Nodes, E = " + e + "\n");
        for (i = 0; i < this.currentNodes; ++i) {
            if (!C.contains(new Integer(i)) || this.zSet.contains(new Integer(i))) continue;
            if (CPlus.contains(new Integer(i))) {
                this.x[i] = this.x[i] + e;
                algorithmtextArea.append("x'[" + (i + 1) + "]=" + this.x[i] + "\n");
            }
            if (!CMinus.contains(new Integer(i))) continue;
            this.x[i] = this.x[i] - e;
            algorithmtextArea.append("x'[" + (i + 1) + "]=" + this.x[i] + "\n");
        }
        if (this.zSet.size() >= 2) {
            for (i = this.zSet.size() - 1; i >= 1; --i) {
                node = this.z[i - 1];
                if (CPlus.contains(new Integer(node))) {
                    this.x[this.z[i]] = this.x[node] + e;
                }
                if (CMinus.contains(new Integer(this.z[i - 1]))) {
                    this.x[this.z[i]] = this.x[node] - e;
                }
                algorithmtextArea.append("x'[" + (this.z[i] + 1) + "]=" + this.x[this.z[i]] + "\n");
            }
            node = this.z[0];
            this.x[node] = e;
            algorithmtextArea.append("x'[" + (node + 1) + "]=" + this.x[node] + "\n");
        }
        if (this.zSet.size() == 1) {
            node = this.z[0];
            this.x[node] = e;
            algorithmtextArea.append("x'[" + (node + 1) + "]=" + this.x[node] + "\n");
        }
        algorithmtextArea.append("--------------------\n");
    }

    public void updateXij(int e, LinkedList CPlus, LinkedList CMinus, TextArea algorithmtextArea, int G, int H) {
        LinkedHashSet C = new LinkedHashSet();
        C.addAll(CPlus);
        C.addAll(CMinus);
        algorithmtextArea.append("UPDATE X(ij) for Arcs, E = " + e + "\n");
        int arc = -1;
        int start = -1;
        int target = -1;
        for (int i = 0; i < this.currentNodes; ++i) {
            if (!C.contains(new Integer(i))) continue;
            arc = this.findArcAboveNodeI(i);
            start = this.arcStartNode[arc];
            target = this.arcTargetNode[arc];
            if (CPlus.contains(new Integer(i))) {
                this.Xij[arc] = this.Xij[arc] + e;
                algorithmtextArea.append("Xij'[" + (start + 1) + "," + (target + 1) + "]=" + this.Xij[arc] + "\n");
            }
            if (!CMinus.contains(new Integer(i))) continue;
            this.Xij[arc] = this.Xij[arc] - e;
            algorithmtextArea.append("Xij'[" + (start + 1) + "," + (target + 1) + "]=" + this.Xij[arc] + "\n");
        }
        arc = this.utilsObj.findArcNumberFromStartAndTargetNodes(G, H, this.nodeArcMatrix, this.currentNodes, this.currentArcs);
        start = this.arcStartNode[arc];
        target = this.arcTargetNode[arc];
        this.Xij[arc] = this.Xij[arc] + e;
        algorithmtextArea.append("Xij'[" + (start + 1) + "," + (target + 1) + "]=" + this.Xij[arc] + "\n");
    }

    public int findArcAboveNodeI(int i) {
        int arc = -1;
        if (this.t[i] == 0) {
            arc = this.utilsObj.findArcNumberFromStartAndTargetNodes(this.p[i], i, this.nodeArcMatrix, this.currentNodes, this.currentArcs);
        } else if (this.t[i] == 1) {
            arc = this.utilsObj.findArcNumberFromStartAndTargetNodes(i, this.p[i], this.nodeArcMatrix, this.currentNodes, this.currentArcs);
        }
        return arc;
    }

    public void createTstarList(int f1, TextArea algorithmtextArea) {
        this.TstarList = new LinkedList();
        LinkedList TstarListDisplay = new LinkedList();
        algorithmtextArea.append("--------------------\n");
        algorithmtextArea.append("Nodes in T*:\n");
        int k = f1;
        this.TstarList.add(new Integer(k));
        k = this.y[k];
        while (this.d[k] > this.d[f1]) {
            this.TstarList.add(new Integer(k));
            k = this.y[k];
        }
        TstarListDisplay = this.utilsObj.incrementListBy1(this.TstarList);
        algorithmtextArea.append("--------------------\n");
        algorithmtextArea.append("T* = " + TstarListDisplay + "\n");
    }

    public void updateWij(int delta, boolean leavingArcIsUp, TextArea algorithmtextArea) {
        algorithmtextArea.append("--------------------\n");
        algorithmtextArea.append("UPDATE W(i) for Tree Nodes:\n");
        algorithmtextArea.append("\u00e4= " + delta + " , ");
        algorithmtextArea.append("T* = " + this.utilsObj.incrementListBy1(this.TstarList) + "\n");
        if (leavingArcIsUp) {
            algorithmtextArea.append("Wi(T')= Wi(T)+\u00e4\n");
        } else {
            algorithmtextArea.append("Wi(T')= Wi(T)-\u00e4\n");
        }
        algorithmtextArea.append("--------------------\n");
        Iterator itr = this.TstarList.iterator();
        int node = -1;
        while (itr.hasNext()) {
            node = (Integer)itr.next();
            if (leavingArcIsUp) {
                algorithmtextArea.append("Wij[" + (node + 1) + "]=" + this.Wij[node] + "==>");
                this.Wij[node] = this.Wij[node] + delta;
                algorithmtextArea.append("Wij'[" + (node + 1) + "]=" + this.Wij[node] + "\n");
                continue;
            }
            algorithmtextArea.append("Wij[" + (node + 1) + "]=" + this.Wij[node] + "==>");
            this.Wij[node] = this.Wij[node] - delta;
            algorithmtextArea.append("Wij'[" + (node + 1) + "]=" + this.Wij[node] + "\n");
        }
    }

    public void updateSij(int delta, boolean leavingArcIsUp, TextArea algorithmtextArea) {
        LinkedHashSet<Integer> Tset = new LinkedHashSet<Integer>();
        for (int i = 0; i < this.currentNodes; ++i) {
            Tset.add(new Integer(i));
        }
        LinkedHashSet<Integer> TSetminusTstarSet = new LinkedHashSet<Integer>();
        TSetminusTstarSet.addAll(Tset);
        TSetminusTstarSet.removeAll(this.TstarList);
        LinkedHashSet<Integer> TgSet = new LinkedHashSet<Integer>();
        LinkedHashSet<Integer> ThSet = new LinkedHashSet<Integer>();
        if (leavingArcIsUp) {
            TgSet.addAll(this.TstarList);
            ThSet.addAll(TSetminusTstarSet);
        } else {
            ThSet.addAll(this.TstarList);
            TgSet.addAll(TSetminusTstarSet);
        }
        algorithmtextArea.append("--------------------\n");
        algorithmtextArea.append("UPDATE S(ij) for Arcs:\n");
        algorithmtextArea.append("Tg =" + this.utilsObj.incrementLinkedHashSetBy1(TgSet) + "\n");
        algorithmtextArea.append("Th =" + this.utilsObj.incrementLinkedHashSetBy1(ThSet) + "\n");
        algorithmtextArea.append("\u00e4= " + delta + "\n");
        Set ArcsSetFromTgToTh = new HashSet();
        ArcsSetFromTgToTh = this.computeSetOfArcs(TgSet, ThSet);
        algorithmtextArea.append("[Tg,Th] Sij(T')=Sij(T) - \u00e4\n");
        algorithmtextArea.append("--------------------\n");
        this.updateSijForArcsInThisSet(ArcsSetFromTgToTh, -delta, algorithmtextArea);
        Set ArcsSetFromThToTg = new HashSet();
        ArcsSetFromThToTg = this.computeSetOfArcs(ThSet, TgSet);
        algorithmtextArea.append("--------------------\n");
        algorithmtextArea.append("[Th,Tg] Sij(T')=Sij(T) + \u00e4\n");
        algorithmtextArea.append("--------------------\n");
        this.updateSijForArcsInThisSet(ArcsSetFromThToTg, delta, algorithmtextArea);
    }

    public Set computeSetOfArcs(Set A, Set B) {
        HashSet<Integer> resultSet = new HashSet<Integer>();
        for (int i = 0; i < this.currentArcs; ++i) {
            if (!A.contains(new Integer(this.arcStartNode[i])) || !B.contains(new Integer(this.arcTargetNode[i]))) continue;
            resultSet.add(new Integer(i));
        }
        return resultSet;
    }

    public void updateSijForArcsInThisSet(Set A, int delta, TextArea algorithmtextArea) {
        Iterator itr = A.iterator();
        int arc = -1;
        int startNode = -1;
        int targetNode = -1;
        while (itr.hasNext()) {
            arc = (Integer)itr.next();
            startNode = this.arcStartNode[arc];
            targetNode = this.arcTargetNode[arc];
            algorithmtextArea.append("Sij[" + (startNode + 1) + "," + (targetNode + 1) + "]=" + this.Sij[arc] + "==>");
            this.Sij[arc] = this.Sij[arc] + delta;
            algorithmtextArea.append("Sij'[" + (startNode + 1) + "," + (targetNode + 1) + "]=" + this.Sij[arc] + "\n");
        }
    }

    public void updateP(int e2, TextArea algorithmtextArea) {
        algorithmtextArea.append("--------------------\n");
        algorithmtextArea.append("UPDATE P(i) for Nodes:\n");
        for (int i = 0; i < this.currentNodes; ++i) {
            if (!this.zSet.contains(new Integer(i))) continue;
            if (i == this.z[0]) {
                this.p[i] = e2;
                algorithmtextArea.append("p'[" + (i + 1) + "]=" + (this.p[i] + 1) + "\n");
                continue;
            }
            int l = -1;
            for (int k = 1; k < this.z.length; ++k) {
                if (i != this.z[k]) continue;
                l = k;
                break;
            }
            this.p[this.z[l]] = this.z[l - 1];
            algorithmtextArea.append("p'[" + (this.z[l] + 1) + "]=" + (this.p[this.z[l]] + 1) + "\n");
        }
    }

    public void updateT(boolean leavingArcIsUP, TextArea algorithmtextArea) {
        algorithmtextArea.append("--------------------\n");
        algorithmtextArea.append("UPDATE T(i) for Nodes:\n");
        if (this.zSet.size() >= 2) {
            for (int i = this.zSet.size() - 1; i >= 1; --i) {
                if (this.t[this.z[i - 1]] == 1) {
                    this.t[this.z[i]] = 0;
                }
                if (this.t[this.z[i - 1]] == 0) {
                    this.t[this.z[i]] = 1;
                }
                algorithmtextArea.append("t'[" + (this.z[i] + 1) + "]=" + this.t[this.z[i]] + "\n");
            }
            this.t[this.z[0]] = !leavingArcIsUP ? 0 : 1;
            algorithmtextArea.append("t'[" + (this.z[0] + 1) + "]=" + this.t[this.z[0]] + "\n");
        }
        if (this.zSet.size() == 1) {
            this.t[this.z[0]] = !leavingArcIsUP ? 0 : 1;
            algorithmtextArea.append("t'[" + (this.z[0] + 1) + "]=" + this.t[this.z[0]] + "\n");
        }
    }

    public void createThreadsYiForEachNodeInZ(int e1, int f1, TextArea algorithmTextArea) {
        this.TstarListCopy = new LinkedList();
        this.TstarListCopy.addAll(this.TstarList);
        int u = this.d[e1] - this.d[f1] + 1;
        this.Yi = new LinkedList[u];
        algorithmTextArea.append("--------------------\n");
        algorithmTextArea.append("Threads Yi for Stem Nodes:\n");
        for (int i = 0; i < u; ++i) {
            this.Yi[i] = new LinkedList();
            this.createYi(this.Yi[i], i);
            algorithmTextArea.append("Y[" + (i + 1) + "]: " + this.utilsObj.incrementListBy1(this.Yi[i]) + "\n");
        }
        algorithmTextArea.append("--------------------\n");
    }

    public void createYi(LinkedList list, int i) {
        int k = this.z[i];
        list.add(new Integer(k));
        k = this.findNodeAfterKInTstarListCopy(k);
        if (k != -1) {
            while (this.d[k] > this.d[this.z[i]]) {
                list.add(new Integer(k));
                if ((k = this.findNodeAfterKInTstarListCopy(k)) != -1) continue;
            }
        }
        this.TstarListCopy.removeAll(list);
    }

    public int findNodeAfterKInTstarListCopy(int nodeK) {
        for (int i = 0; i < this.TstarListCopy.size(); ++i) {
            if ((Integer)this.TstarListCopy.get(i) != nodeK || i > this.TstarListCopy.size() - 2) continue;
            return (Integer)this.TstarListCopy.get(i + 1);
        }
        return -1;
    }

    public void updateD(int f, TextArea algorithmTextArea) {
        algorithmTextArea.append("UPDATE D(i) for Nodes in Yi:\n");
        int node = -1;
        for (int i = 0; i < this.Yi.length; ++i) {
            for (int j = 0; j < this.Yi[i].size(); ++j) {
                node = (Integer)this.Yi[i].get(j);
                this.d[node] = this.d[node] + f + 2 * i;
                algorithmTextArea.append("d'[" + (node + 1) + "]= " + this.d[node] + "\n");
            }
        }
    }

    public void createViLYiXiRYiUi(TextArea algorithmTextArea) {
        int i;
        this.Vi = new int[this.Yi.length];
        this.LYi = new LinkedList[this.Yi.length];
        this.Xi = new int[this.Yi.length];
        this.RYi = new LinkedList[this.Yi.length];
        this.Ui = new int[this.Yi.length];
        algorithmTextArea.append("--------------------\n");
        algorithmTextArea.append("Find Vi ,LYi, Xi,RYi, Ui:\n");
        for (i = 0; i < this.Yi.length; ++i) {
            this.Vi[i] = (Integer)this.Yi[i].getLast();
            algorithmTextArea.append("Vi[" + (i + 1) + "]= " + (this.Vi[i] + 1) + "\n");
        }
        this.LYi[0] = null;
        this.Xi[0] = 0;
        this.RYi[0] = null;
        this.Ui[0] = 0;
        for (i = 1; i < this.Yi.length; ++i) {
            this.LYi[i] = new LinkedList();
            this.findLeftList(this.LYi[i], this.Yi[i], i);
            algorithmTextArea.append("LYi[" + (i + 1) + "]= " + this.utilsObj.incrementListBy1(this.LYi[i]) + "\n");
            if (this.LYi[i].size() > 0) {
                this.Xi[i] = (Integer)this.LYi[i].getLast();
                algorithmTextArea.append("Xi[" + (i + 1) + "]= " + (this.Xi[i] + 1) + "\n");
            }
            this.RYi[i] = new LinkedList();
            this.findRightList(this.RYi[i], this.Yi[i], i);
            algorithmTextArea.append("RYi[" + (i + 1) + "]= " + this.utilsObj.incrementListBy1(this.RYi[i]) + "\n");
            if (this.RYi[i].size() <= 0) continue;
            this.Ui[i] = (Integer)this.RYi[i].getFirst();
            algorithmTextArea.append("Ui[" + (i + 1) + "]= " + (this.Ui[i] + 1) + "\n");
        }
    }

    public void findLeftList(LinkedList LYi, LinkedList Yi, int i) {
        int node = -1;
        if (Yi.size() > 0) {
            node = (Integer)Yi.getFirst();
            LYi.add(new Integer(node));
            for (int k = 1; k < Yi.size(); ++k) {
                node = (Integer)Yi.get(k);
                if (!this.thisNodeIsBeforeZiminus1InY(node, i)) continue;
                LYi.add(new Integer(node));
            }
        }
    }

    public boolean thisNodeIsBeforeZiminus1InY(int node, int i) {
        boolean result = false;
        if (this.TstarList.indexOf(new Integer(node)) < this.TstarList.indexOf(new Integer(this.z[i - 1]))) {
            result = true;
        }
        return result;
    }

    public void findRightList(LinkedList RYi, LinkedList Yi, int i) {
        int node = -1;
        if (Yi.size() > 0) {
            for (int k = 0; k < Yi.size(); ++k) {
                node = (Integer)Yi.get(k);
                if (!this.thisNodeIsAfterZiminus1InY(node, i)) continue;
                RYi.add(new Integer(node));
            }
        }
    }

    public boolean thisNodeIsAfterZiminus1InY(int node, int i) {
        boolean result = false;
        if (this.TstarList.indexOf(new Integer(node)) > this.TstarList.indexOf(new Integer(this.z[i - 1]))) {
            result = true;
        }
        return result;
    }

    public void findNodesJandVandB(int e2, int f1, TextArea algorithmTextArea) {
        algorithmTextArea.append("--------------------\n");
        for (int i = 0; i < this.y.length; ++i) {
            if (this.y[i] != f1) continue;
            this.J = i;
            break;
        }
        algorithmTextArea.append("J = " + (this.J + 1) + " \n");
        int lastNodeInTstarSet = (Integer)this.TstarList.getLast();
        this.V = this.y[lastNodeInTstarSet];
        algorithmTextArea.append("V = " + (this.V + 1) + " \n");
        for (int i = 0; i < this.y.length; ++i) {
            if (i != e2) continue;
            this.B = this.y[i];
            break;
        }
        algorithmTextArea.append("B = " + (this.B + 1) + " \n");
    }

    public void updateY(int e2, int e1) {
        int i;
        this.y[this.J] = this.V;
        for (i = 0; i <= this.Vi.length - 2; ++i) {
            this.y[this.Vi[i]] = this.z[i + 1];
        }
        this.y[this.Vi[this.Vi.length - 1]] = this.y[e2];
        if (e2 == this.J) {
            this.y[this.Vi[this.Vi.length - 1]] = this.V;
        }
        for (i = 1; i < this.RYi.length; ++i) {
            if (this.RYi[i].size() <= 0) continue;
            this.y[this.Xi[i]] = this.Ui[i];
        }
        this.y[e2] = e1;
    }

    public void savePreviousNodeCoordinates() {
        System.arraycopy(this.CenterX, 0, this.previousCenterX, 0, this.currentNodes);
        System.arraycopy(this.CenterY, 0, this.previousCenterY, 0, this.currentNodes);
    }

    public void savePreviousArcCoordinates() {
        System.arraycopy(this.arcStartXCoordinate, 0, this.previousArcStartXCoordinate, 0, this.currentArcs);
        System.arraycopy(this.arcStartYCoordinate, 0, this.previousArcStartYCoordinate, 0, this.currentArcs);
        System.arraycopy(this.arcEndXCoordinate, 0, this.previousArcEndXCoordinate, 0, this.currentArcs);
        System.arraycopy(this.arcEndYCoordinate, 0, this.previousArcEndYCoordinate, 0, this.currentArcs);
        System.arraycopy(this.arcCenterXCoordinate, 0, this.previousArcCenterXCoordinate, 0, this.currentArcs);
        System.arraycopy(this.arcCenterYCoordinate, 0, this.previousArcCenterYCoordinate, 0, this.currentArcs);
    }

    public void displayArcsInCycle(FontMetrics myFontMetrics, Graphics2D g2d, LinkedList CPlus, LinkedList CMinus) {
        g2d.setStroke(new BasicStroke(1.8f));
        LinkedList Cycle = new LinkedList();
        int node = -1;
        int arc = -1;
        int x = 0;
        int y = 0;
        int w = 0;
        int h = 0;
        Cycle.addAll(CPlus);
        Cycle.addAll(CMinus);
        Iterator itr = Cycle.iterator();
        while (itr.hasNext()) {
            node = (Integer)itr.next();
            if (this.t[node] == 1) {
                arc = this.utilsObj.findArcNumberFromStartAndTargetNodes(node, this.p[node], this.nodeArcMatrix, this.currentNodes, this.currentArcs);
            }
            if (this.t[node] == 0) {
                arc = this.utilsObj.findArcNumberFromStartAndTargetNodes(this.p[node], node, this.nodeArcMatrix, this.currentNodes, this.currentArcs);
            }
            g2d.setColor(Color.green);
            this.arrowObj.drawTreeArrow(g2d, this.arcStartXCoordinate[arc], this.arcStartYCoordinate[arc], this.arcEndXCoordinate[arc], this.arcEndYCoordinate[arc]);
            x = this.arcCenterXCoordinate[arc];
            y = this.arcCenterYCoordinate[arc];
            this.displayUtilsObj.drawBlankRectForArcCost(this.Xij[arc], arc, myFontMetrics, x, y, g2d);
            w = myFontMetrics.stringWidth(String.valueOf(this.Xij[arc]));
            g2d.setColor(Color.red);
            g2d.drawString(String.valueOf(this.Xij[arc]), x - w / 2, y);
            g2d.setColor(Color.white);
            g2d.fillRect(this.CenterX[node] - 14 - 2, this.CenterY[node] - 20 - h, myFontMetrics.stringWidth(String.valueOf(this.Wij[node])) + 2, h + 2);
            g2d.fillRect(this.CenterX[this.p[node]] - 14 - 2, this.CenterY[this.p[node]] - 20 - h, myFontMetrics.stringWidth(String.valueOf(this.Wij[this.p[node]])) + 2, h + 2);
            g2d.setColor(Color.blue);
            g2d.drawString(String.valueOf(this.Wij[node]), this.CenterX[node] - 14, this.CenterY[node] - 20);
            g2d.drawString(String.valueOf(this.Wij[this.p[node]]), this.CenterX[this.p[node]] - 14, this.CenterY[this.p[node]] - 20);
        }
        g2d.setStroke(new BasicStroke());
        g2d.setColor(Color.black);
    }

    public void drawPlusOrMinus(Graphics g, LinkedList CPlus, LinkedList CMinus, Font myDrawFont) {
        int node = -1;
        Iterator itr = CPlus.iterator();
        while (itr.hasNext()) {
            node = (Integer)itr.next();
            if (this.t[node] == 1) {
                this.arrowObj.drawPlusOrMinus('+', g, this.CenterX[node], this.CenterY[node], this.CenterX[this.p[node]], this.CenterY[this.p[node]], myDrawFont);
            }
            if (this.t[node] != 0) continue;
            this.arrowObj.drawPlusOrMinus('+', g, this.CenterX[this.p[node]], this.CenterY[this.p[node]], this.CenterX[node], this.CenterY[node], myDrawFont);
        }
        itr = CMinus.iterator();
        while (itr.hasNext()) {
            node = (Integer)itr.next();
            if (this.t[node] == 1) {
                this.arrowObj.drawPlusOrMinus('-', g, this.CenterX[node], this.CenterY[node], this.CenterX[this.p[node]], this.CenterY[this.p[node]], myDrawFont);
            }
            if (this.t[node] != 0) continue;
            this.arrowObj.drawPlusOrMinus('-', g, this.CenterX[this.p[node]], this.CenterY[this.p[node]], this.CenterX[node], this.CenterY[node], myDrawFont);
        }
    }

    public void findArcsInTStar(Set BasicArcs) {
        this.tStarArcs = new LinkedList();
        int arc = -1;
        int startNode = -1;
        int targetNode = -1;
        Iterator it = BasicArcs.iterator();
        while (it.hasNext()) {
            arc = (Integer)it.next();
            startNode = this.arcStartNode[arc];
            targetNode = this.arcTargetNode[arc];
            if (!(this.TstarList.contains(new Integer(startNode)) & this.TstarList.contains(new Integer(targetNode)))) continue;
            this.tStarArcs.add(new Integer(arc));
        }
    }

    public void displayPreviousBigMTree(Graphics2D g, Set BasicArcs, Set NonBasicArcs, int entering, FontMetrics myFontMetrics) {
        int i;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        int w = 0;
        Color lightSlateGray = new Color(153, 153, 255);
        g.setColor(lightSlateGray);
        for (i = 0; i < this.currentNodes; ++i) {
            if (this.TstarList.contains(new Integer(i))) continue;
            g.fillOval(this.previousCenterX[i] - 10, this.previousCenterY[i] - 10, 20, 20);
        }
        g.setColor(Color.black);
        for (i = 0; i <= this.currentArcs; ++i) {
            if (!(BasicArcs.contains(new Integer(i)) & !this.tStarArcs.contains(new Integer(i)) & i != entering)) continue;
            g.setColor(Color.BLACK);
            this.arrowObj.drawTreeArrow(g, this.previousArcStartXCoordinate[i], this.previousArcStartYCoordinate[i], this.previousArcEndXCoordinate[i], this.previousArcEndYCoordinate[i]);
        }
        int h = myFontMetrics.getHeight();
        for (int i2 = 0; i2 < this.currentNodes; ++i2) {
            if (this.TstarList.contains(new Integer(i2))) continue;
            g.setColor(Color.BLACK);
            w = myFontMetrics.stringWidth(String.valueOf(i2 + 1));
            g.drawString(Integer.toString(i2 + 1), this.previousCenterX[i2] - w / 2, this.previousCenterY[i2] + h / 4);
        }
        boolean WijWidth = false;
        for (int i3 = 0; i3 <= this.currentNodes - 1; ++i3) {
            if (this.TstarList.contains(new Integer(i3))) continue;
            g.setColor(Color.white);
            g.fillRect(this.previousCenterX[i3] - 14 - 2, this.previousCenterY[i3] - 20 - h, myFontMetrics.stringWidth(String.valueOf(this.Wij[i3])) + 2, h + 2);
            g.setColor(Color.blue);
            g.drawString(String.valueOf(this.Wij[i3]), this.previousCenterX[i3] - 14, this.previousCenterY[i3] - 20);
        }
        int x = 0;
        int y = 0;
        for (int i4 = 0; i4 < this.currentArcs; ++i4) {
            if (!(BasicArcs.contains(new Integer(i4)) & !this.tStarArcs.contains(new Integer(i4)) & i4 != entering)) continue;
            x = this.previousArcCenterXCoordinate[i4];
            y = this.previousArcCenterYCoordinate[i4];
            w = myFontMetrics.stringWidth(String.valueOf(this.Xij[i4]));
            g.setColor(Color.white);
            g.fillRect(x - w / 2 - 2, y - h, w + 4, h + 3);
            g.setColor(Color.red);
            g.drawString(String.valueOf(this.Xij[i4]), x - w / 2, y);
        }
    }
}

