/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public class DisplayUtils {
    Line lineObj = new Line();
    Arrow arrowObj = new Arrow();
    Utils utilsObj = new Utils();
    EnteringArc enteringArcObj = new EnteringArc();

    public void displayTopoLabels(Graphics2D g2, LinkedList topoOrder, int[] CoordinateX, int[] CoordinateY) {
        int visitOrder = 1;
        int node = 0;
        g2.setColor(new Color(51, 204, 255));
        g2.setFont(new Font("Helvetica", 0, 14));
        Iterator it = topoOrder.iterator();
        while (it.hasNext()) {
            node = (Integer)it.next();
            g2.drawString("" + visitOrder, CoordinateX[--node] + 42, CoordinateY[node] + 10);
            ++visitOrder;
        }
        g2.setFont(new Font("Arial", 1, 12));
    }

    public void displayNodeLabel(Graphics g, int node, Color labelColor, String label, FontMetrics myFontMetrics, int[] CoordinateX, int[] CoordinateY) {
        int w = myFontMetrics.charWidth('0');
        int h = myFontMetrics.getHeight();
        String strMaxInt = Integer.toString(Integer.MAX_VALUE);
        int strMaxIntWidth = myFontMetrics.stringWidth(strMaxInt);
        int labelWidth = myFontMetrics.stringWidth(label);
        int labelHeight = h;
        int xTopLeft = CoordinateX[node] - 10;
        int yTopLeft = CoordinateY[node] - 24;
        strMaxIntWidth = labelWidth + 6;
        labelHeight = 1 + h;
        g.setColor(Color.white);
        g.fillRect(xTopLeft, yTopLeft, strMaxIntWidth, labelHeight);
        g.setColor(labelColor);
        g.fillRect(xTopLeft, yTopLeft, labelWidth += 6, labelHeight);
        g.setColor(Color.white);
        int xCenter = xTopLeft + labelWidth / 2;
        int yCenter = yTopLeft + labelHeight / 2;
        int w2 = myFontMetrics.stringWidth(label);
        g.drawString(label, xCenter - w2 / 2, yCenter + h / 2 - 2);
        g.setColor(Color.black);
    }

    public void displayArcs(Graphics2D g2, Color color, int currentArcs, int[] arcStartXCoordinate, int[] arcStartYCoordinate, int[] arcEndXCoordinate, int[] arcEndYCoordinate, boolean directedYes) {
        g2.setStroke(new BasicStroke(2.0f));
        for (int i = 0; i < currentArcs; ++i) {
            g2.setColor(color);
            if (directedYes) {
                this.arrowObj.drawArrow(g2, arcStartXCoordinate[i], arcStartYCoordinate[i], arcEndXCoordinate[i], arcEndYCoordinate[i]);
            }
            if (directedYes) continue;
            g2.drawLine(arcStartXCoordinate[i], arcStartYCoordinate[i], arcEndXCoordinate[i], arcEndYCoordinate[i]);
        }
        g2.setStroke(new BasicStroke());
    }

    public void drawBlankRectForNodeSupply(int nodeSupply, int node, FontMetrics myFontMetrics, int[] CoordinateX, int[] CoordinateY, Graphics g) {
        int h = myFontMetrics.getHeight();
        g.setColor(Color.white);
        g.fillRect(CoordinateX[node] - 4 - 2, CoordinateY[node] - 8 - h, myFontMetrics.stringWidth(String.valueOf(nodeSupply)) + 3, h + 1);
    }

    public void drawBlankRectForArcCost(int arcCost, int arc, FontMetrics myFontMetrics, int x, int y, Graphics g) {
        int h = myFontMetrics.getHeight();
        int w = myFontMetrics.stringWidth(String.valueOf(arcCost));
        g.setColor(Color.white);
        g.fillRect(x - 2, y - h, w + 4, h + 3);
    }

    public void drawArcCostsAgain(int startNode, int targetNode, int arcNumber, Graphics g, int[][] Adjacency, int[][] nodeArcMatrix, int[] arcCosts, int[] arcCenterXCoordinate, int[] arcCenterYCoordinate, int[] arcEndXCoordinate, int[] arcEndYCoordinate, int currentNodes, int currentArcs) {
        if (!this.utilsObj.existOppositeArc(startNode, targetNode, Adjacency, currentNodes)) {
            g.setColor(Color.red);
            g.drawString(String.valueOf(arcCosts[arcNumber]), arcCenterXCoordinate[arcNumber], arcCenterYCoordinate[arcNumber]);
        } else {
            g.drawString(String.valueOf(arcCosts[arcNumber]), (arcCenterXCoordinate[arcNumber] + arcEndXCoordinate[arcNumber]) / 2, (arcCenterYCoordinate[arcNumber] + arcEndYCoordinate[arcNumber]) / 2);
            int oppositeArc = this.utilsObj.findArcNumberFromStartAndTargetNodes(targetNode, startNode, nodeArcMatrix, currentNodes, currentArcs);
            g.drawString(String.valueOf(arcCosts[oppositeArc]), (arcCenterXCoordinate[oppositeArc] + arcEndXCoordinate[oppositeArc]) / 2, (arcCenterYCoordinate[oppositeArc] + arcEndYCoordinate[oppositeArc]) / 2);
        }
    }

    public void drawArcCostsAgain(int startNode, int targetNode, int i, Graphics g, int[][] Adjacency, int[][] nodeArcMatrix, int[] arcCosts, int[] arcCenterXCoordinate, int[] arcCenterYCoordinate, int[] arcEndXCoordinate, int[] arcEndYCoordinate, int currentNodes, int currentArcs, FontMetrics myFontMetrics) {
        if (!this.utilsObj.existOppositeArc(startNode, targetNode, Adjacency, currentNodes)) {
            this.drawBlankRectForArcCost(arcCosts[i], i, myFontMetrics, arcCenterXCoordinate[i], arcCenterYCoordinate[i], g);
            g.setColor(Color.red);
            g.drawString(String.valueOf(arcCosts[i]), arcCenterXCoordinate[i], arcCenterYCoordinate[i]);
        } else {
            this.drawBlankRectForArcCost(arcCosts[i], i, myFontMetrics, (arcCenterXCoordinate[i] + arcEndXCoordinate[i]) / 2, (arcCenterYCoordinate[i] + arcEndYCoordinate[i]) / 2, g);
            g.setColor(Color.red);
            g.drawString(String.valueOf(arcCosts[i]), (arcCenterXCoordinate[i] + arcEndXCoordinate[i]) / 2, (arcCenterYCoordinate[i] + arcEndYCoordinate[i]) / 2);
            int j = this.utilsObj.findArcNumberFromStartAndTargetNodes(targetNode, startNode, nodeArcMatrix, currentNodes, currentArcs);
            this.drawBlankRectForArcCost(arcCosts[j], j, myFontMetrics, (arcCenterXCoordinate[j] + arcEndXCoordinate[j]) / 2, (arcCenterYCoordinate[j] + arcEndYCoordinate[j]) / 2, g);
            g.setColor(Color.red);
            g.drawString(String.valueOf(arcCosts[j]), (arcCenterXCoordinate[j] + arcEndXCoordinate[j]) / 2, (arcCenterYCoordinate[j] + arcEndYCoordinate[j]) / 2);
        }
    }

    public void displayNode2(FontMetrics myFontMetrics, int node, Graphics2D g2, int x, int y, Color color, Color labelColor) {
        Color lightSlateGray = new Color(153, 153, 255);
        GradientPaint redtoblue = new GradientPaint(x - 10, y - 10, Color.red, x + 10, y + 10, lightSlateGray);
        int w = 0;
        int h = 0;
        g2.setPaint(color);
        g2.fillOval(x - 10, y - 10, 20, 20);
        g2.setColor(labelColor);
        h = myFontMetrics.getHeight();
        w = myFontMetrics.stringWidth(String.valueOf(node + 1));
        g2.drawString(Integer.toString(node + 1), x - w / 2, y + h / 4);
    }

    public void displayNode(FontMetrics myFontMetrics, int node, Graphics2D g2, int x, int y) {
        Color lightSlateGray = new Color(153, 153, 255);
        GradientPaint redtoblue = new GradientPaint(x - 10, y - 10, Color.red, x + 10, y + 10, lightSlateGray);
        int w = 0;
        int h = 0;
        g2.setPaint(lightSlateGray);
        g2.fillOval(x - 10, y - 10, 20, 20);
        g2.setColor(Color.black);
        h = myFontMetrics.getHeight();
        w = myFontMetrics.stringWidth(String.valueOf(node + 1));
        g2.drawString(Integer.toString(node + 1), x - w / 2, y + h / 4);
    }

    public void clearNode(Graphics2D g2, int x, int y, Color color) {
        g2.setColor(color);
        g2.fillOval(x - 11, y - 11, 22, 22);
    }

    public void calculatePointsAndAnimate(FontMetrics myFontMetrics, Graphics2D g2d, Graphics2D g2dbig, Image offImage, Dimension dim, LinkedList tStar, LinkedList tStarArcs, Set zSet, Set BasicArcs, int enteringArc, int[] previousCenterX, int[] previousCenterY, int[] CenterX, int[] CenterY, int[] arcStartNode, int[] arcTargetNode, int currentNodes, int currentArcs, int G, int H, boolean up, int delay) {
        int i;
        Point p1 = null;
        Point p2 = null;
        Point p3 = null;
        Point p4 = null;
        boolean node = false;
        boolean arc = false;
        int startNode = 0;
        int targetNode = 0;
        Point[][] nodeCenterPoints = new Point[currentNodes][49];
        Point[][] arcStartPoints = new Point[currentArcs][49];
        Point[][] arcEndPoints = new Point[currentArcs][49];
        for (i = 0; i < currentNodes; ++i) {
            this.lineObj.p1 = new Point(previousCenterX[i], previousCenterY[i]);
            this.lineObj.p2 = new Point(CenterX[i], CenterY[i]);
            this.lineObj.findLineEquation();
            this.lineObj.findDistance();
            nodeCenterPoints[i] = this.lineObj.findNumOfPoints(50);
        }
        for (i = 0; i < currentArcs; ++i) {
            startNode = arcStartNode[i];
            targetNode = arcTargetNode[i];
            for (int j = 0; j <= 48; ++j) {
                p1 = nodeCenterPoints[startNode][j];
                p2 = nodeCenterPoints[targetNode][j];
                p3 = new Point();
                p4 = new Point();
                this.utilsObj.calculateIntersectPoints(p1, p2, p3, p4, 20);
                arcStartPoints[i][j] = p3;
                arcEndPoints[i][j] = p4;
            }
        }
        for (int j = 0; j < 49; ++j) {
            int i2;
            for (i2 = 0; i2 < currentNodes; ++i2) {
                if (tStar.contains(new Integer(i2))) {
                    this.displayNode2(myFontMetrics, i2, g2d, nodeCenterPoints[i2][j].x, nodeCenterPoints[i2][j].y, Color.red, Color.white);
                    if (!zSet.contains(new Integer(i2))) continue;
                    g2d.setStroke(new BasicStroke(2.0f));
                    g2d.setColor(Color.blue);
                    g2d.drawOval(nodeCenterPoints[i2][j].x - 10, nodeCenterPoints[i2][j].y - 10, 20, 20);
                    g2d.setStroke(new BasicStroke());
                    continue;
                }
                this.displayNode2(myFontMetrics, i2, g2d, nodeCenterPoints[i2][j].x, nodeCenterPoints[i2][j].y, new Color(153, 153, 255), Color.black);
            }
            g2d.setColor(Color.black);
            for (i2 = 0; i2 < currentArcs; ++i2) {
                if (!(BasicArcs.contains(new Integer(i2)) & i2 != enteringArc)) continue;
                this.arrowObj.drawTreeArrow(g2d, arcStartPoints[i2][j].x, arcStartPoints[i2][j].y, arcEndPoints[i2][j].x, arcEndPoints[i2][j].y);
            }
            if (up) {
                this.enteringArcObj.drawEnteringArc(g2d, new Point(nodeCenterPoints[G][j].x, nodeCenterPoints[G][j].y), new Point(nodeCenterPoints[H][j].x, nodeCenterPoints[H][j].y), Color.green);
            } else {
                this.enteringArcObj.drawEnteringArc(g2d, new Point(nodeCenterPoints[G][j].x, nodeCenterPoints[G][j].y), new Point(nodeCenterPoints[H][j].x, nodeCenterPoints[H][j].y), Color.green);
            }
            this.utilsObj.delay(delay);
            g2d.drawImage(offImage, null, null);
        }
        for (i = 0; i < currentNodes; ++i) {
            this.displayNode2(myFontMetrics, i, g2d, nodeCenterPoints[i][48].x, nodeCenterPoints[i][48].y, new Color(153, 153, 255), Color.black);
        }
        g2d.setColor(Color.black);
        for (i = 0; i < currentArcs; ++i) {
            if (!BasicArcs.contains(new Integer(i))) continue;
            this.arrowObj.drawTreeArrow(g2d, arcStartPoints[i][48].x, arcStartPoints[i][48].y, arcEndPoints[i][48].x, arcEndPoints[i][48].y);
        }
        if (up) {
            this.enteringArcObj.drawEnteringArc(g2d, new Point(nodeCenterPoints[G][48].x, nodeCenterPoints[G][48].y), new Point(nodeCenterPoints[H][48].x, nodeCenterPoints[H][48].y), Color.green);
        } else {
            this.enteringArcObj.drawEnteringArc(g2d, new Point(nodeCenterPoints[G][48].x, nodeCenterPoints[G][48].y), new Point(nodeCenterPoints[H][48].x, nodeCenterPoints[H][48].y), Color.green);
        }
    }

    public Rectangle findRectFromPoints(LinkedList listOfPoints) {
        Rectangle result = new Rectangle();
        return result;
    }
}

