/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;

public class EnteringArc {
    public void drawEnteringArc(Graphics2D g2, Point p1, Point p2, Color color) {
        Point ctrl = this.calculateControlPoint(p1, p2);
        float p1x = (float)p1.getX();
        float p1y = (float)p1.getY();
        float p2x = (float)p2.getX();
        float p2y = (float)p2.getY();
        float cx = (float)ctrl.getX();
        float cy = (float)ctrl.getY();
        GeneralPath line = new GeneralPath();
        g2.setPaint(color);
        line.moveTo(p1x, p1y);
        line.quadTo(cx, cy, p2x, p2y);
        g2.setStroke(new BasicStroke(1.8f, 1, 1, 1.0f, new float[]{5.0f, 7.0f}, 0.0f));
        if (color == Color.white) {
            g2.setStroke(new BasicStroke(2.0f));
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        } else {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g2.draw(line);
        float arrSize = 14.0f;
        float adjSize = (float)((double)arrSize / Math.sqrt(2.0));
        float ex = p2x - cx;
        float ey = p2y - cy;
        float abs_e = (float)Math.sqrt(ex * ex + ey * ey);
        GeneralPath arrow = new GeneralPath();
        arrow.moveTo(p2x, p2y);
        arrow.lineTo(p2x + ((ey /= abs_e) - (ex /= abs_e)) * adjSize, p2y - (ex + ey) * adjSize);
        arrow.moveTo(p2x, p2y);
        arrow.lineTo(p2x - (ey + ex) * adjSize, p2y + (ex - ey) * adjSize);
        arrow.lineTo(p2x + (ey - ex) * adjSize, p2y - (ex + ey) * adjSize);
        g2.setStroke(new BasicStroke());
        g2.fill(arrow);
    }

    public Point calculateControlPoint(Point p1, Point p2) {
        Point ctrl = new Point(0, 0);
        double mx = (p1.getX() + p2.getX()) / 2.0;
        double my = (p1.getY() + p2.getY()) / 2.0;
        if (p1.getX() == p2.getX()) {
            ctrl.setLocation(p1.getX() - 40.0, my);
            if (p1.getY() < p2.getY()) {
                p1.setLocation(p1.getX(), p1.getY() + 10.0);
                p2.setLocation(p2.getX(), p2.getY() - 10.0);
            } else {
                p2.setLocation(p2.getX(), p2.getY() + 10.0);
                p1.setLocation(p1.getX(), p1.getY() - 10.0);
            }
        } else if (p1.getY() == p2.getY()) {
            ctrl.setLocation(mx, p1.getY() + 40.0);
            if (p2.getX() > p1.getX()) {
                p1.setLocation(p1.getX() + 10.0, p1.getY());
                p2.setLocation(p2.getX() - 10.0, p2.getY());
            } else {
                p2.setLocation(p2.getX() + 10.0, p2.getY());
                p1.setLocation(p1.getX() - 10.0, p1.getY());
            }
        } else if (p2.getX() > p1.getX() && p2.getY() > p1.getY()) {
            ctrl.setLocation(mx - 40.0, my + 40.0);
            p1.setLocation(p1.getX(), p1.getY() + 10.0);
            p2.setLocation(p2.getX() - 10.0, p2.getY());
        } else if (p2.getX() < p1.getX() && p2.getY() > p1.getY()) {
            ctrl.setLocation(mx + 40.0, my + 40.0);
            p1.setLocation(p1.getX(), p1.getY() + 10.0);
            p2.setLocation(p2.getX() + 10.0, p2.getY());
        } else if (p2.getX() > p1.getX() && p2.getY() < p1.getY()) {
            ctrl.setLocation(mx - 40.0, my - 40.0);
            p1.setLocation(p1.getX(), p1.getY() - 10.0);
            p2.setLocation(p2.getX() - 10.0, p2.getY());
        } else if (p2.getX() < p1.getX() && p2.getY() < p1.getY()) {
            ctrl.setLocation(mx + 40.0, my - 40.0);
            p1.setLocation(p1.getX(), p1.getY() - 10.0);
            p2.setLocation(p2.getX() + 10.0, p2.getY());
        }
        return ctrl;
    }
}

