/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;

public class LeavingArc {
    int aw = 60;
    int haw = this.aw / 2;
    int[] xValues = new int[3];
    int[] yValues = new int[3];

    public void drawLeavingArc(Graphics g, int x1, int y1, int x2, int y2) {
        double dist = Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
        double al = dist / 2.0;
        this.calcValues(x1, y1, x2, y2, (int)al);
        g.drawLine(this.xValues[1], this.yValues[1], this.xValues[2], this.yValues[2]);
        this.calcValues(x1, y1, x2, y2, (int)(al -= 10.0));
        g.drawLine(this.xValues[1], this.yValues[1], this.xValues[2], this.yValues[2]);
    }

    public void calcValues(int x1, int y1, int x2, int y2, int al) {
        if (x1 == x2) {
            if (y2 < y1) {
                this.arrowCoords(x2, y2, x2 - this.haw, y2 + al, x2 + this.haw, y2 + al);
            } else {
                this.arrowCoords(x2, y2, x2 - this.haw, y2 - al, x2 + this.haw, y2 - al);
            }
            return;
        }
        if (y1 == y2) {
            if (x2 > x1) {
                this.arrowCoords(x2, y2, x2 - al, y2 - this.haw, x2 - al, y2 + this.haw);
            } else {
                this.arrowCoords(x2, y2, x2 + al, y2 - this.haw, x2 + al, y2 + this.haw);
            }
            return;
        }
        this.calcValuesQuad(x1, y1, x2, y2, al);
    }

    public void calcValuesQuad(int x1, int y1, int x2, int y2, int al) {
        double arrowAng = Math.toDegrees(Math.atan((double)this.haw / (double)al));
        double dist = Math.sqrt(al * al + this.aw);
        double lineAng = Math.toDegrees(Math.atan((double)Math.abs(x1 - x2) / (double)Math.abs(y1 - y2)));
        if (x1 > x2) {
            if (y1 > y2) {
                lineAng = 180.0 - lineAng;
            }
        } else {
            lineAng = y1 > y2 ? 180.0 + lineAng : 360.0 - lineAng;
        }
        this.xValues[0] = x2;
        this.yValues[0] = y2;
        this.calcCoords(1, x2, y2, dist, lineAng - arrowAng);
        this.calcCoords(2, x2, y2, dist, lineAng + arrowAng);
    }

    public void calcCoords(int index, int x, int y, double dist, double dirn) {
        while (dirn < 0.0) {
            dirn = 360.0 + dirn;
        }
        while (dirn > 360.0) {
            dirn -= 360.0;
        }
        if (dirn <= 90.0) {
            this.xValues[index] = x + (int)(Math.sin(Math.toRadians(dirn)) * dist);
            this.yValues[index] = y - (int)(Math.cos(Math.toRadians(dirn)) * dist);
            return;
        }
        if (dirn <= 180.0) {
            this.xValues[index] = x + (int)(Math.cos(Math.toRadians(dirn - 90.0)) * dist);
            this.yValues[index] = y + (int)(Math.sin(Math.toRadians(dirn - 90.0)) * dist);
            return;
        }
        if (dirn <= 90.0) {
            this.xValues[index] = x - (int)(Math.sin(Math.toRadians(dirn - 180.0)) * dist);
            this.yValues[index] = y + (int)(Math.cos(Math.toRadians(dirn - 180.0)) * dist);
        } else {
            this.xValues[index] = x - (int)(Math.cos(Math.toRadians(dirn - 270.0)) * dist);
            this.yValues[index] = y - (int)(Math.sin(Math.toRadians(dirn - 270.0)) * dist);
        }
    }

    public void arrowCoords(int x1, int y1, int x2, int y2, int x3, int y3) {
        this.xValues[0] = x1;
        this.yValues[0] = y1;
        this.xValues[1] = x2;
        this.yValues[1] = y2;
        this.xValues[2] = x3;
        this.yValues[2] = y3;
    }
}

