/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class Utils {
    Arrow arrowObj = new Arrow();
    Dialog dialog;
    boolean dialogResult;
    Button dialogYesButton;
    Button dialogNoButton;
    Button dialogOkButton;
    Panel dialogButtonsPanel;

    Frame findParentFrame(Applet appletObj) {
        for (Container c = appletObj; c != null; c = c.getParent()) {
            if (!(c instanceof Frame)) continue;
            return (Frame)c;
        }
        return null;
    }

    public void showModalDialogNewGraph(Applet appletObj) {
        Frame parentFrame = this.findParentFrame(appletObj);
        if (parentFrame != null) {
            this.dialogYesButton = new Button("Yes ");
            this.dialogNoButton = new Button("No");
            this.dialogYesButton.addActionListener(new dialogYesButtonActionListener());
            this.dialogNoButton.addActionListener(new dialogNoButtonActionListener());
            this.dialog = new Dialog(parentFrame, "WARNING", true);
            this.dialog.addWindowListener(new dialogWindowListener());
            this.dialog.add((Component)new Label("The old Graph will be discarded.Proceed? (Yes/No)"), "Center");
            this.dialogButtonsPanel = new Panel();
            this.dialogButtonsPanel.setLayout(new GridLayout(1, 2, 5, 5));
            this.dialogButtonsPanel.add(this.dialogYesButton);
            this.dialogButtonsPanel.add(this.dialogNoButton);
            this.dialog.add((Component)this.dialogButtonsPanel, "South");
            this.dialog.pack();
            this.dialog.setLocation(300, 10);
            this.dialog.setVisible(true);
        }
    }

    public void showModalDialogEmptyGraph(Applet appletObj) {
        Frame parentFrame = this.findParentFrame(appletObj);
        if (parentFrame != null) {
            this.dialogOkButton = new Button("OK ");
            this.dialogOkButton.addActionListener(new dialogOkButtonActionListener());
            this.dialog = new Dialog(parentFrame, "WARNING", true);
            this.dialog.addWindowListener(new dialogWindowListener());
            this.dialog.add((Component)new Label("You must create a new Graph"), "Center");
            this.dialogButtonsPanel = new Panel();
            this.dialogButtonsPanel.setLayout(new GridLayout(1, 2, 5, 5));
            this.dialogButtonsPanel.add(this.dialogOkButton);
            this.dialog.add((Component)this.dialogButtonsPanel, "South");
            this.dialog.pack();
            this.dialog.setLocation(300, 10);
            this.dialog.setVisible(true);
        }
    }

    public void calculateIntersectPoints(Point p1, Point p2, Point p3, Point p4, int myNodeDiameter) {
        Point p31 = new Point(0, 0);
        Point p32 = new Point(0, 0);
        Point p41 = new Point(0, 0);
        Point p42 = new Point(0, 0);
        double x1 = p1.getX();
        double y1 = p1.getY();
        double x2 = p2.getX();
        double y2 = p2.getY();
        if (x1 != x2) {
            double m = (y2 - y1) / (x2 - x1);
            double n = y1 - m * x1;
            double r = myNodeDiameter / 2;
            double a = 1.0 + m * m;
            double b = 2.0 * m * n - 2.0 * m * y1 - 2.0 * x1;
            double c = x1 * x1 - 2.0 * n * y1 + y1 * y1 - r * r + n * n;
            double D = b * b - 4.0 * a * c;
            double x31 = (-b + Math.sqrt(D)) / (2.0 * a);
            double y31 = m * x31 + n;
            double x32 = (-b - Math.sqrt(D)) / (2.0 * a);
            double y32 = m * x32 + n;
            a = 1.0 + m * m;
            b = 2.0 * m * n - 2.0 * m * y2 - 2.0 * x2;
            c = x2 * x2 - 2.0 * n * y2 + y2 * y2 - r * r + n * n;
            D = b * b - 4.0 * a * c;
            double x41 = (-b + Math.sqrt(D)) / (2.0 * a);
            double y41 = m * x41 + n;
            double x42 = (-b - Math.sqrt(D)) / (2.0 * a);
            double y42 = m * x42 + n;
            p31.setLocation(x31, y31);
            p32.setLocation(x32, y32);
            p41.setLocation(x41, y41);
            p42.setLocation(x42, y42);
            double d3141 = Math.sqrt((x31 - x41) * (x31 - x41) + (y31 - y41) * (y31 - y41));
            double d3142 = Math.sqrt((x31 - x42) * (x31 - x42) + (y31 - y42) * (y31 - y42));
            double min1 = Math.min(d3141, d3142);
            double d3241 = Math.sqrt((x32 - x41) * (x32 - x41) + (y32 - y41) * (y32 - y41));
            double d3242 = Math.sqrt((x32 - x42) * (x32 - x42) + (y32 - y42) * (y32 - y42));
            double min2 = Math.min(d3241, d3242);
            double min = Math.min(min1, min2);
            if (min == d3141) {
                p3.setLocation(p31);
                p4.setLocation(p41);
            }
            if (min == d3142) {
                p3.setLocation(p31);
                p4.setLocation(p42);
            }
            if (min == d3241) {
                p3.setLocation(p32);
                p4.setLocation(p41);
            }
            if (min == d3242) {
                p3.setLocation(p32);
                p4.setLocation(p42);
            }
        } else {
            if (y2 > y1) {
                p3.setLocation(x1, y1 + (double)(myNodeDiameter / 2));
                p4.setLocation(x1, y2 - (double)(myNodeDiameter / 2));
            }
            if (y2 < y1) {
                p3.setLocation(x1, y1 - (double)(myNodeDiameter / 2));
                p4.setLocation(x1, y2 + (double)(myNodeDiameter / 2));
            }
        }
    }

    public void calculateOneIntersectPoint(Point p1, Point p2, Point p3, int myNodeDiameter) {
        Point p31 = new Point(0, 0);
        Point p32 = new Point(0, 0);
        double x1 = p1.getX();
        double y1 = p1.getY();
        double x2 = p2.getX();
        double y2 = p2.getY();
        double m = (y2 - y1) / (x2 - x1);
        double n = y1 - m * x1;
        double r = myNodeDiameter / 2;
        double a = 1.0 + m * m;
        double b = 2.0 * m * n - 2.0 * m * y1 - 2.0 * x1;
        double c = x1 * x1 - 2.0 * n * y1 + y1 * y1 - r * r + n * n;
        double D = b * b - 4.0 * a * c;
        double x31 = (-b + Math.sqrt(D)) / (2.0 * a);
        double y31 = m * x31 + n;
        double x32 = (-b - Math.sqrt(D)) / (2.0 * a);
        double y32 = m * x32 + n;
        p31.setLocation(x31, y31);
        p32.setLocation(x32, y32);
        double d312 = Math.sqrt((x31 - x2) * (x31 - x2) + (y31 - y2) * (y31 - y2));
        double d322 = Math.sqrt((x32 - x2) * (x32 - x2) + (y32 - y2) * (y32 - y2));
        double min = Math.min(d312, d322);
        if (min == d312) {
            p3.setLocation(p31);
        }
        if (min == d322) {
            p3.setLocation(p32);
        }
    }

    public boolean isTextInvalid(String text) {
        boolean isTextInvalid = false;
        if (text.length() == 0) {
            isTextInvalid = true;
            return isTextInvalid;
        }
        if (text.charAt(0) == '-' & text.length() == 1) {
            isTextInvalid = true;
            return isTextInvalid;
        }
        String tempString = text;
        tempString = text.substring(1);
        char[] charArray = tempString.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            if (charArray[i] != '-') continue;
            isTextInvalid = true;
            return isTextInvalid;
        }
        String maxIntString = String.valueOf(Integer.MAX_VALUE);
        int maxLenght = maxIntString.length();
        char ch = text.charAt(0);
        if (ch == '-') {
            ++maxLenght;
        }
        if (text.length() > maxLenght) {
            isTextInvalid = true;
            return isTextInvalid;
        }
        long num = Long.parseLong(text);
        if (num > Integer.MAX_VALUE | num < Integer.MIN_VALUE) {
            isTextInvalid = true;
            return isTextInvalid;
        }
        return isTextInvalid;
    }

    public boolean isInValidSetOfChars(int c, int[] validSetOfChars) {
        boolean isValid = false;
        for (int i = 0; i < validSetOfChars.length; ++i) {
            if (c != validSetOfChars[i]) continue;
            isValid = true;
        }
        return isValid;
    }

    public boolean validateCoords(int currentNodes, int mxDoubleClick, int myDoubleClick, int[] CoordinateX, int[] CoordinateY, int canvasWidth, int canvasHeight, int myNodeDiameter, int myNodeToNodeDistance, int myNodeDistanceFromCanvasBorder) {
        int i;
        boolean X1 = false;
        boolean X2 = false;
        boolean X3 = false;
        boolean X4 = false;
        boolean Y1 = false;
        boolean Y2 = false;
        boolean Y3 = false;
        boolean Y4 = false;
        boolean result0 = false;
        boolean result1 = true;
        boolean[] result = new boolean[currentNodes];
        for (i = 0; i < result.length; ++i) {
            result[i] = false;
        }
        if (currentNodes >= 1) {
            for (i = 0; i <= currentNodes - 1; ++i) {
                X1 = mxDoubleClick >= CoordinateX[i] + myNodeDiameter + myNodeToNodeDistance;
                X2 = mxDoubleClick <= CoordinateX[i] - myNodeToNodeDistance;
                Y1 = myDoubleClick >= CoordinateY[i] + myNodeDiameter + myNodeToNodeDistance;
                Y2 = myDoubleClick <= CoordinateY[i] - myNodeToNodeDistance;
                result[i] = X1 | X2 | Y1 | Y2;
                result1 = result[i] & result1;
            }
        }
        X3 = mxDoubleClick >= myNodeDistanceFromCanvasBorder;
        X4 = mxDoubleClick <= canvasWidth - myNodeDistanceFromCanvasBorder - myNodeDiameter;
        Y3 = myDoubleClick >= myNodeDistanceFromCanvasBorder;
        Y4 = myDoubleClick <= canvasHeight - myNodeDistanceFromCanvasBorder - myNodeDiameter;
        result0 = X3 & X4 & Y3 & Y4;
        if (currentNodes == 0) {
            return result0;
        }
        return result0 & result1;
    }

    public int nodeSearch(int currentNodes, int x, int y, int[] CoordinateX, int[] CoordinateY, int myNodeDiameter) {
        int position = 0;
        boolean found = false;
        for (int i = 0; i <= currentNodes - 1; ++i) {
            if (!(x >= CoordinateX[i] & x <= CoordinateX[i] + myNodeDiameter & y >= CoordinateY[i] & y <= CoordinateY[i] + myNodeDiameter)) continue;
            position = i;
            found = true;
        }
        if (found) {
            return position;
        }
        return -1;
    }

    public boolean existOppositeArc(int arcStartNode, int arcTargetNode, int[][] Adjacency, int currentNodes) {
        boolean exist = false;
        for (int i = 0; i < currentNodes; ++i) {
            for (int j = 0; j < currentNodes; ++j) {
                if (Adjacency[arcTargetNode][arcStartNode] != 1) continue;
                exist = true;
            }
        }
        return exist;
    }

    public int findOppositeArc(int arcNumber, int currentArcs, int[] arcStartNode, int[] arcTargetNode) {
        int oppositeArc = -1;
        for (int i = 0; i < currentArcs; ++i) {
            if (!(arcStartNode[i] == arcTargetNode[arcNumber] & arcTargetNode[i] == arcStartNode[arcNumber])) continue;
            oppositeArc = i;
            return oppositeArc;
        }
        return -1;
    }

    public boolean isGraphConnected(int currentNodes, int[][] Adjacency, boolean[] wasVisited, int maxNodes) {
        int i;
        int node = 0;
        StackX theStack = new StackX(maxNodes);
        for (i = 0; i < currentNodes; ++i) {
            wasVisited[i] = false;
        }
        wasVisited[node] = true;
        theStack.push(node);
        while (!theStack.isEmpty()) {
            node = theStack.pop();
            for (int j = 0; j < currentNodes; ++j) {
                if (!((Adjacency[node][j] == 1 | Adjacency[j][node] == 1) & !wasVisited[j])) continue;
                wasVisited[j] = true;
                theStack.push(j);
            }
        }
        for (i = 0; i < currentNodes; ++i) {
            if (wasVisited[i]) continue;
            return false;
        }
        return true;
    }

    public boolean graphNodesHaveBeenVisited(boolean[] wasVisited, int currentNodes) {
        for (int i = 0; i < currentNodes; ++i) {
            if (wasVisited[i]) continue;
            return false;
        }
        return true;
    }

    public boolean graphHasNegativeCosts(int[] arcCosts, int currentArcs) {
        for (int i = 0; i < currentArcs; ++i) {
            if (arcCosts[i] >= 0) continue;
            return true;
        }
        return false;
    }

    public int findStartNodeFromArcNumber(int[][] nodeArcMatrix, int currentNodes, int arcNumber) {
        for (int i = 0; i < currentNodes; ++i) {
            if (nodeArcMatrix[i][arcNumber] != 1) continue;
            return i;
        }
        return -1;
    }

    public int findStartNodeFromArcNumberUndirectedGraphs(int[][] nodeArcMatrix, int currentNodes, int arcNumber) {
        for (int i = 0; i < currentNodes; ++i) {
            if (nodeArcMatrix[i][arcNumber] != 1) continue;
            return i;
        }
        return -1;
    }

    public int findTargetNodeFromArcNumber(int[][] nodeArcMatrix, int currentNodes, int arcNumber) {
        for (int i = 0; i < currentNodes; ++i) {
            if (nodeArcMatrix[i][arcNumber] != -1) continue;
            return i;
        }
        return -1;
    }

    public int findTargetNodeFromArcNumberUndirectedGraphs(int[][] nodeArcMatrix, int currentNodes, int arcNumber) {
        for (int i = currentNodes - 1; i >= 0; --i) {
            if (nodeArcMatrix[i][arcNumber] != 1) continue;
            return i;
        }
        return -1;
    }

    public int findArcNumberFromStartAndTargetNodes(int startNode, int targetNode, int[][] nodeArcMatrix, int currentNodes, int currentArcs) {
        for (int j = 0; j < currentArcs; ++j) {
            if (!(nodeArcMatrix[startNode][j] == 1 & nodeArcMatrix[targetNode][j] == -1)) continue;
            return j;
        }
        return -1;
    }

    public int findArcNumberFromStartAndTargetNodesDirectedGraphs(int startNode, int targetNode, int[][] nodeArcMatrix, int currentNodes, int currentArcs) {
        for (int j = 0; j < currentArcs; ++j) {
            if (!(nodeArcMatrix[startNode][j] == 1 & nodeArcMatrix[targetNode][j] == -1)) continue;
            return j;
        }
        return -1;
    }

    public int findArcNumberFromStartAndTargetNodesUndirectedGraphs(int startNode, int targetNode, int[][] nodeArcMatrix, int currentNodes, int currentArcs) {
        for (int j = 0; j < currentArcs; ++j) {
            if (!(nodeArcMatrix[startNode][j] == 1 & nodeArcMatrix[targetNode][j] == 1)) continue;
            return j;
        }
        return -1;
    }

    public void deleteElementFrom1dIntArray(int[] array, int size, int position) {
        for (int i = position; i <= size - 2; ++i) {
            array[i] = array[i + 1];
        }
        array[size - 1] = 0;
    }

    public void deleteElementFrom1dObjectsArray(Object[] array, int size, int position) {
        for (int i = position; i <= size - 2; ++i) {
            array[i] = array[i + 1];
        }
        array[size - 1] = null;
    }

    public void deleteElementFrom1dArray(int[] array, int size, int position) {
        for (int i = position; i <= size - 2; ++i) {
            array[i] = array[i + 1];
        }
        array[size - 1] = -1;
    }

    public void deleteColumnFrom2dArray(int[][] array, int rows, int columns, int column) {
        for (int i = column; i <= columns - 2; ++i) {
            for (int row = 0; row <= rows - 1; ++row) {
                array[row][i] = array[row][i + 1];
            }
        }
        for (int row = 0; row <= rows - 1; ++row) {
            array[row][columns - 1] = 0;
        }
    }

    public void deleteRowFrom2dArray(int[][] array, int rows, int columns, int row) {
        for (int i = row; i <= rows - 2; ++i) {
            for (int column = 0; column <= columns - 1; ++column) {
                array[i][column] = array[i + 1][column];
            }
        }
        for (int column = 0; column <= columns - 1; ++column) {
            array[rows - 1][column] = 0;
        }
    }

    public void arcsSetToBeDeleted(int[][] nodeArcMatrix, int currentArcs, int nodeToDelete, SortedSet arcsSet) {
        for (int arc = 0; arc <= currentArcs - 1; ++arc) {
            if (nodeArcMatrix[nodeToDelete][arc] == 0) continue;
            arcsSet.add(new Integer(arc));
        }
    }

    public void createSortedSetWithOutArcsFromStoS1(Set a, Set b, Set c, int[][] Adjacency, int[][] nodeArcMatrix, int currentNodes, int currentArcs, StringBuffer str, String fromTo) {
        boolean exists = false;
        int int1 = -1;
        int int2 = -1;
        int arcNumber = -1;
        Integer obj1 = null;
        Integer obj22 = null;
        Iterator aIterator = a.iterator();
        str.append("Candidate Arcs\n");
        str.append(new StringBuffer(fromTo));
        while (aIterator.hasNext()) {
            obj1 = (Integer)aIterator.next();
            int1 = obj1;
            --int1;
            for (Integer obj22 : b) {
                int2 = obj22;
                if (Adjacency[int1][--int2] != 1) continue;
                exists = true;
                arcNumber = this.findArcNumberFromStartAndTargetNodes(int1, int2, nodeArcMatrix, currentNodes, currentArcs);
                c.add(new Integer(arcNumber + 1));
                str.append("(" + (int1 + 1) + "," + (int2 + 1) + ")" + "\n");
            }
        }
        if (!exists) {
            str.append("There aren't candidate arcs\n");
            str.append(new StringBuffer(fromTo));
        }
    }

    public void createSortedSetWithUndirectedArcsFromStoS1(Set a, Set b, Set c, int[][] Adjacency, int[][] nodeArcMatrix, int currentNodes, int currentArcs, StringBuffer str) {
        boolean exists = false;
        int int1 = -1;
        int int2 = -1;
        int arcNumber = -1;
        Integer obj1 = null;
        Integer obj22 = null;
        Iterator aIterator = a.iterator();
        str.append("Candidate Edges\n");
        str.append("from S to S'\n");
        while (aIterator.hasNext()) {
            obj1 = (Integer)aIterator.next();
            int1 = obj1;
            --int1;
            for (Integer obj22 : b) {
                int2 = obj22;
                if (Adjacency[int1][--int2] != 1) continue;
                exists = true;
                arcNumber = this.findArcNumberFromStartAndTargetNodesUndirectedGraphs(int1, int2, nodeArcMatrix, currentNodes, currentArcs);
                c.add(new Integer(arcNumber + 1));
                str.append("(" + (int1 + 1) + "," + (int2 + 1) + ")" + "\n");
            }
        }
        if (!exists) {
            str.append("There aren't candidate Edges\n");
            str.append("from S to S'\n");
        }
    }

    public void createSortedSetWithDirectedArcsFromAdjacency(LinkedList arcsSet, int[][] Adjacency, int[][] nodeArcMatrix, int currentNodes, int currentArcs) {
        int arcNumber = -1;
        for (int i = 0; i < currentNodes; ++i) {
            for (int j = 0; j < currentNodes; ++j) {
                if (Adjacency[i][j] != 1) continue;
                arcNumber = this.findArcNumberFromStartAndTargetNodesDirectedGraphs(i, j, nodeArcMatrix, currentNodes, currentArcs);
                arcsSet.add(new Integer(arcNumber + 1));
            }
        }
    }

    public void createSortedSetWithUndirectedArcsFromAdjacency(Set arcsSet, Map costMapArcOrder, int[] arcOrder, int[] arcCosts, int[][] Adjacency, int[][] nodeArcMatrix, int currentNodes, int currentArcs) {
        int arcNumber = -1;
        for (int i = 0; i < currentNodes; ++i) {
            for (int j = 0; j < currentNodes; ++j) {
                if (Adjacency[i][j] != 1) continue;
                arcNumber = this.findArcNumberFromStartAndTargetNodesUndirectedGraphs(i, j, nodeArcMatrix, currentNodes, currentArcs);
                arcsSet.add(new Integer(arcNumber + 1));
                costMapArcOrder.put(new Integer(arcOrder[arcNumber] + 1), new Integer(arcCosts[arcNumber]));
            }
        }
    }

    public void sortArcsAccordingToAdjacency(int currentNodes, int currentArcs, int[][] Adjacency, int[] arcOrder, int[] arcStartNode, int[] arcTargetNode) {
        int arcNumber = 0;
        int seira = 0;
        if (currentArcs >= 1) {
            for (int i = 0; i < currentNodes; ++i) {
                for (int j = 0; j < currentNodes; ++j) {
                    if (Adjacency[i][j] != 1) continue;
                    for (int arc = 0; arc <= currentArcs; ++arc) {
                        if (!(arcStartNode[arc] == i & arcTargetNode[arc] == j)) continue;
                        arcNumber = arc;
                        arcOrder[arcNumber] = seira++;
                    }
                }
            }
        } else {
            arcOrder[arcNumber] = 0;
        }
    }

    public int findArcFromArcOrder(int order, int[] arcOrder, int currentArcs) {
        for (int i = 0; i < currentArcs; ++i) {
            if (arcOrder[i] != order) continue;
            return i;
        }
        return -1;
    }

    public boolean setOfNonVisitedAdjacentNodes(int node, StringBuffer str, int currentNodes, int[][] Adjacency, boolean[] wasVisited) {
        TreeSet<Integer> adjacentNodes = new TreeSet<Integer>();
        boolean exist = false;
        str.append("***************************\n");
        for (int j = 0; j < currentNodes; ++j) {
            if (!((Adjacency[node][j] == 1 | Adjacency[j][node] == 1) & !wasVisited[j])) continue;
            exist = true;
            adjacentNodes.add(new Integer(j + 1));
        }
        if (!exist) {
            str.append("There aren't unvisited nodes adjacent to " + (node + 1) + "\n");
        } else {
            str.append("The set of unvisited nodes adjacent to node " + (node + 1) + " is: " + adjacentNodes + "\n");
        }
        str.append("***************************\n");
        return exist;
    }

    public int findLeftmostAdjNodeOfStackPeek(int peek, int[][] Adjacency, int currentNodes, boolean[] wasVisited) {
        for (int j = 0; j < currentNodes; ++j) {
            if (!(Adjacency[peek][j] == 1 & !wasVisited[j])) continue;
            return j;
        }
        return -1;
    }

    public boolean sumOfNodesSuppliesIsEqualToZero(int currentNodes, int[] nodeSupplies) {
        int sum = 0;
        for (int i = 0; i < currentNodes; ++i) {
            sum += nodeSupplies[i];
        }
        return sum == 0;
    }

    public int computeBigM(int currentNodes, int currentArcs, int[] nodeSupplies, int[] arcCosts) {
        if (currentNodes == 1) {
            return 1;
        }
        int U = 0;
        for (int i = 0; i < currentNodes; ++i) {
            if (nodeSupplies[i] <= 0) continue;
            U += nodeSupplies[i];
        }
        int[] absoluteArcCosts = new int[currentArcs];
        for (int i = 0; i < currentArcs; ++i) {
            absoluteArcCosts[i] = Math.abs(arcCosts[i]);
        }
        Arrays.sort(absoluteArcCosts, 0, currentArcs);
        int C = absoluteArcCosts[currentArcs - 1];
        int M = (currentNodes - 1) * C * U + 1;
        return M;
    }

    public void copyAdjacency(int[][] from, int fromDim, int[][] to) {
        for (int i = 0; i < fromDim; ++i) {
            for (int j = 0; j < fromDim; ++j) {
                to[i][j] = from[i][j];
            }
        }
    }

    public void copyNodeArc(int[][] from, int fromRows, int fromCols, int[][] to) {
        for (int i = 0; i < fromRows; ++i) {
            for (int j = 0; j < fromCols; ++j) {
                to[i][j] = from[i][j];
            }
        }
    }

    public void createSetsNsAndNd(int[] nodeSupplies, int currentNodes, Set Ns, Set Nd) {
        for (int i = 0; i < currentNodes; ++i) {
            if (nodeSupplies[i] > 0) {
                Ns.add(new Integer(i));
                continue;
            }
            Nd.add(new Integer(i));
        }
    }

    public int computeEnteringArc(int[] arcOrder, int[] arcStartNode, int[] arcTargetNode, int[] Sij, Set NonBasicArcs, int currentArcs, TextArea algorithmTextArea) {
        Set arcSet;
        TreeMap<Integer, Integer> negativeSijMapForNonBasicArcs = new TreeMap<Integer, Integer>();
        TreeMap<Integer, Integer> positiveSijMapForNonBasicArcs = new TreeMap<Integer, Integer>();
        int arcNumber = -1;
        Iterator<Object> itr = NonBasicArcs.iterator();
        while (itr.hasNext()) {
            arcNumber = (Integer)itr.next();
            if (Sij[arcNumber] < 0) {
                negativeSijMapForNonBasicArcs.put(new Integer(arcOrder[arcNumber]), new Integer(Sij[arcNumber]));
            }
            if (Sij[arcNumber] < 0) continue;
            positiveSijMapForNonBasicArcs.put(new Integer(arcOrder[arcNumber]), new Integer(Sij[arcNumber]));
        }
        if (!positiveSijMapForNonBasicArcs.isEmpty()) {
            algorithmTextArea.append("-------------------------\n");
            algorithmTextArea.append("Non Basic Arcs with Sij>=0:\n");
            algorithmTextArea.append("-------------------------\n");
            arcSet = positiveSijMapForNonBasicArcs.keySet();
            itr = arcSet.iterator();
            while (itr.hasNext()) {
                arcNumber = (Integer)itr.next();
                arcNumber = this.findArcFromArcOrder(arcNumber, arcOrder, currentArcs);
                algorithmTextArea.append("S (" + (arcStartNode[arcNumber] + 1) + "," + (arcTargetNode[arcNumber] + 1) + ")=" + Sij[arcNumber] + "\n");
            }
            System.out.println("Positive SijS = " + positiveSijMapForNonBasicArcs);
            algorithmTextArea.append("-------------------------\n");
        }
        algorithmTextArea.append("Non Basic Arcs with Sij<0:\n");
        algorithmTextArea.append("-------------------------\n");
        if (!negativeSijMapForNonBasicArcs.isEmpty()) {
            arcSet = negativeSijMapForNonBasicArcs.keySet();
            itr = arcSet.iterator();
            while (itr.hasNext()) {
                arcNumber = (Integer)itr.next();
                arcNumber = this.findArcFromArcOrder(arcNumber, arcOrder, currentArcs);
                algorithmTextArea.append("S (" + (arcStartNode[arcNumber] + 1) + "," + (arcTargetNode[arcNumber] + 1) + ")=" + Sij[arcNumber] + "\n");
            }
            System.out.println("Negative SijS = " + negativeSijMapForNonBasicArcs);
            algorithmTextArea.append("-------------------------\n");
            Collection sijCollection = negativeSijMapForNonBasicArcs.values();
            Integer minSijObj = (Integer)Collections.min(sijCollection);
            int minSijValue = minSijObj;
            algorithmTextArea.append("MINIMUM \u00e4=Sgh(T)<0 = " + minSijValue + "\n");
            Set set = negativeSijMapForNonBasicArcs.entrySet();
            for (Map.Entry mapEntry : set) {
                if ((Integer)mapEntry.getValue() != minSijValue) continue;
                arcNumber = (Integer)mapEntry.getKey();
                arcNumber = this.findArcFromArcOrder(arcNumber, arcOrder, currentArcs);
                algorithmTextArea.append("G= " + (arcStartNode[arcNumber] + 1) + "\n");
                algorithmTextArea.append("H= " + (arcTargetNode[arcNumber] + 1) + "\n");
                algorithmTextArea.append("Entering Arc= (" + (arcStartNode[arcNumber] + 1) + "," + (arcTargetNode[arcNumber] + 1) + ")\n");
                return arcNumber;
            }
        } else {
            algorithmTextArea.append("There aren't Nonbasic Arcs with negative Sij\n");
            return -1;
        }
        return -1;
    }

    public int[] computeJoinAndLeavingArc(int root, int G, int H, int[] p, int[] t, int[] d, int[] x, LinkedList CPlus, LinkedList CMinus, TextArea algorithmTextArea) {
        int[] joinNodeAndLeavingArc = new int[]{-1, -1, -1, -1};
        LinkedList<Integer> CgPlus = new LinkedList<Integer>();
        LinkedList<Integer> CgMinus = new LinkedList<Integer>();
        LinkedList<Integer> ChPlus = new LinkedList<Integer>();
        LinkedList<Integer> ChMinus = new LinkedList<Integer>();
        LinkedList<Integer> CgPlusDisplay = new LinkedList<Integer>();
        LinkedList<Integer> CgMinusDisplay = new LinkedList<Integer>();
        LinkedList<Integer> ChPlusDisplay = new LinkedList<Integer>();
        LinkedList<Integer> ChMinusDisplay = new LinkedList<Integer>();
        LinkedList<Integer> CPlusDisplay = new LinkedList<Integer>();
        LinkedList<Integer> CMinusDisplay = new LinkedList<Integer>();
        int Eg = 0;
        int Eh = 0;
        int E = 0;
        int K = -1;
        int L = -1;
        int leavingArc = -1;
        int join = -1;
        LinkedList<Integer> nodesFromGToRoot = new LinkedList<Integer>();
        LinkedList<Integer> nodesFromHToRoot = new LinkedList<Integer>();
        LinkedList<Integer> nodesIntersection = new LinkedList<Integer>();
        int i = G;
        nodesFromGToRoot.add(new Integer(i));
        while (i != root) {
            i = p[i];
            nodesFromGToRoot.add(new Integer(i));
        }
        System.out.println("nodesFromGToRoot" + nodesFromGToRoot);
        int j = H;
        nodesFromHToRoot.add(new Integer(j));
        while (j != root) {
            j = p[j];
            nodesFromHToRoot.add(new Integer(j));
        }
        System.out.println("nodesFromHToRoot" + nodesFromHToRoot);
        nodesIntersection.addAll(nodesFromGToRoot);
        nodesIntersection.retainAll(nodesFromHToRoot);
        System.out.println("nodesIntersection" + nodesIntersection);
        Object[] objArray = nodesIntersection.toArray();
        int[] intArray = new int[objArray.length];
        int[] depthArray = new int[intArray.length];
        for (int node = 0; node < intArray.length; ++node) {
            intArray[node] = (Integer)objArray[node];
            depthArray[node] = d[intArray[node]];
        }
        int max = depthArray[0];
        join = intArray[0];
        for (int node = 1; node < depthArray.length; ++node) {
            if (depthArray[node] <= max) continue;
            max = depthArray[node];
            join = intArray[node];
        }
        joinNodeAndLeavingArc[0] = join;
        algorithmTextArea.append("join node= " + (join + 1) + "\n");
        System.out.println("join" + (join + 1));
        i = G;
        while (i != join) {
            if (t[i] == 0) {
                CgPlus.add(new Integer(i));
                CgPlusDisplay.add(new Integer(i + 1));
            }
            if (t[i] == 1) {
                CgMinus.add(new Integer(i));
                CgMinusDisplay.add(new Integer(i + 1));
            }
            i = p[i];
        }
        j = H;
        while (j != join) {
            if (t[j] == 0) {
                ChMinus.add(new Integer(j));
                ChMinusDisplay.add(new Integer(j + 1));
            }
            if (t[j] == 1) {
                ChPlus.add(new Integer(j));
                ChPlusDisplay.add(new Integer(j + 1));
            }
            j = p[j];
        }
        algorithmTextArea.append("Cg+= " + CgPlusDisplay + "\n");
        algorithmTextArea.append("Cg-= " + CgMinusDisplay + "\n");
        algorithmTextArea.append("Ch+= " + ChPlusDisplay + "\n");
        algorithmTextArea.append("Ch-= " + ChMinusDisplay + "\n");
        CPlus.addAll(CgPlus);
        CPlus.addAll(ChPlus);
        CMinus.addAll(CgMinus);
        CMinus.addAll(ChMinus);
        System.out.println("CPlus" + CPlus);
        System.out.println("CMinus" + CMinus);
        CPlusDisplay.addAll(CgPlusDisplay);
        CPlusDisplay.addAll(ChPlusDisplay);
        CMinusDisplay.addAll(CgMinusDisplay);
        CMinusDisplay.addAll(ChMinusDisplay);
        algorithmTextArea.append("C+= " + CPlusDisplay + "\n");
        algorithmTextArea.append("C-= " + CMinusDisplay + "\n");
        int[] KAndXK = new int[]{-1, -1};
        int[] LAndXL = new int[]{-1, -1};
        if (CgMinus.size() > 0) {
            KAndXK = this.findKAndXK(CgMinus, x, d);
            K = KAndXK[0];
            Eg = KAndXK[1];
        }
        if (ChMinus.size() > 0) {
            LAndXL = this.findLAndXL(ChMinus, x, d);
            L = LAndXL[0];
            Eh = LAndXL[1];
        }
        if (CgMinus.size() > 0 && ChMinus.size() == 0) {
            K = KAndXK[0];
            L = p[K];
            E = Eg;
            algorithmTextArea.append("E=X(" + (K + 1) + ")= " + E + "\n");
        }
        if (ChMinus.size() > 0 && CgMinus.size() == 0) {
            L = LAndXL[0];
            K = p[L];
            E = Eh;
            algorithmTextArea.append("E=X(" + (L + 1) + ")= " + E + "\n");
        }
        if (CgMinus.size() != 0 && ChMinus.size() != 0) {
            if (Eg <= Eh) {
                K = KAndXK[0];
                L = p[K];
                E = Eg;
                algorithmTextArea.append("E=X(" + (K + 1) + ")= " + E + "\n");
            } else {
                L = LAndXL[0];
                K = p[L];
                E = Eh;
                algorithmTextArea.append("E=X(" + (L + 1) + ")= " + E + "\n");
            }
        }
        joinNodeAndLeavingArc[1] = K;
        joinNodeAndLeavingArc[2] = L;
        joinNodeAndLeavingArc[3] = E;
        if (CMinus.size() > 0) {
            algorithmTextArea.append("K= " + (K + 1) + "\n");
            algorithmTextArea.append("L= " + (L + 1) + "\n");
            System.out.println("leavingArc" + (K + 1) + "-" + (L + 1));
            algorithmTextArea.append("E= " + E + "\n");
        }
        return joinNodeAndLeavingArc;
    }

    public int[] findKAndXK(LinkedList CgMinus, int[] x, int[] d) {
        int[] KAndXK = new int[]{-1, -1};
        Object[] CgMinusObj = CgMinus.toArray();
        System.out.println("CgMinus.size= " + CgMinus.size());
        int[] gNodeArray = new int[CgMinusObj.length];
        int[] gXArray = new int[gNodeArray.length];
        int[] gDepthArray = new int[gNodeArray.length];
        for (int node = 0; node < gNodeArray.length; ++node) {
            gNodeArray[node] = (Integer)CgMinusObj[node];
            gXArray[node] = x[gNodeArray[node]];
            gDepthArray[node] = d[gNodeArray[node]];
        }
        int[] gXArraySorted = new int[gNodeArray.length];
        System.arraycopy(gXArray, 0, gXArraySorted, 0, gXArray.length);
        Arrays.sort(gXArraySorted);
        int minXiInCgMinus = gXArraySorted[0];
        HashSet<Integer> depthSet = new HashSet<Integer>();
        for (int node = 0; node < gNodeArray.length; ++node) {
            if (gXArray[node] != minXiInCgMinus) continue;
            depthSet.add(new Integer(gDepthArray[node]));
        }
        int minDepth = (Integer)Collections.min(depthSet);
        int k = -1;
        for (int node = 0; node < gNodeArray.length; ++node) {
            if (gDepthArray[node] != minDepth) continue;
            k = gNodeArray[node];
            break;
        }
        KAndXK[0] = k;
        KAndXK[1] = minXiInCgMinus;
        System.out.println("k= " + k);
        System.out.println("X(k)= " + minXiInCgMinus);
        return KAndXK;
    }

    public int[] findLAndXL(LinkedList ChMinus, int[] x, int[] d) {
        int[] LAndXL = new int[]{-1, -1};
        Object[] ChMinusObj = ChMinus.toArray();
        int[] hNodeArray = new int[ChMinusObj.length];
        int[] hXArray = new int[hNodeArray.length];
        int[] hDepthArray = new int[hNodeArray.length];
        for (int node = 0; node < hNodeArray.length; ++node) {
            hNodeArray[node] = (Integer)ChMinusObj[node];
            hXArray[node] = x[hNodeArray[node]];
            hDepthArray[node] = d[hNodeArray[node]];
        }
        int[] hXArraySorted = new int[hNodeArray.length];
        System.arraycopy(hXArray, 0, hXArraySorted, 0, hXArray.length);
        Arrays.sort(hXArraySorted);
        int minXiInChMinus = hXArraySorted[0];
        HashSet<Integer> depthSet = new HashSet<Integer>();
        for (int node = 0; node < hNodeArray.length; ++node) {
            if (hXArray[node] != minXiInChMinus) continue;
            depthSet.add(new Integer(hDepthArray[node]));
        }
        int maxDepth = (Integer)Collections.max(depthSet);
        int l = -1;
        for (int node = 0; node < hNodeArray.length; ++node) {
            if (hDepthArray[node] != maxDepth) continue;
            l = hNodeArray[node];
            break;
        }
        LAndXL[0] = l;
        LAndXL[1] = minXiInChMinus;
        return LAndXL;
    }

    public LinkedList incrementListBy1(LinkedList list) {
        LinkedList<Integer> resultList = new LinkedList<Integer>();
        Iterator itr = list.iterator();
        int value = -1;
        while (itr.hasNext()) {
            value = (Integer)itr.next();
            resultList.add(new Integer(value + 1));
        }
        return resultList;
    }

    public LinkedHashSet incrementLinkedHashSetBy1(Set list) {
        LinkedHashSet<Integer> resultList = new LinkedHashSet<Integer>();
        Iterator itr = list.iterator();
        int value = -1;
        while (itr.hasNext()) {
            value = (Integer)itr.next();
            resultList.add(new Integer(value + 1));
        }
        return resultList;
    }

    public int findMaxDepth(int[] d, int currentNodes) {
        int maxDepth = d[0];
        for (int i = 0; i < currentNodes; ++i) {
            if (d[i] <= maxDepth) continue;
            maxDepth = d[i];
        }
        return maxDepth;
    }

    public int numOfNodesOneLevelBelow(int currentNode, int currentNodes, int[] d) {
        int num = 0;
        for (int i = 0; i < currentNodes; ++i) {
            if (d[i] != d[currentNode] + 1) continue;
            ++num;
        }
        return num;
    }

    public LinkedList findChildsInPreorder(LinkedList TList, int node, int[] p) {
        LinkedList<Integer> resultList = new LinkedList<Integer>();
        int k = 0;
        Iterator it = TList.iterator();
        while (it.hasNext()) {
            k = (Integer)it.next();
            if (p[k] != node) continue;
            resultList.add(new Integer(k));
        }
        return resultList;
    }

    public boolean allArtificialVariablesZero(int[] Xij, int currentArcs, Set ArtificialArcs) {
        boolean allZero = true;
        for (int i = 0; i < currentArcs; ++i) {
            if (!ArtificialArcs.contains(new Integer(i)) || Xij[i] == 0) continue;
            allZero = false;
            break;
        }
        return allZero;
    }

    public void delay(int delay) {
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean isDigraphAcyclic(int currentNodes, int[] inDegree, int[][] Adjacency, LinkedList topoOrder) {
        int i;
        boolean result = false;
        StackX theStack = new StackX(currentNodes);
        int[] tempInDegree = new int[currentNodes];
        boolean[] wasVisited = new boolean[currentNodes];
        for (i = 0; i < currentNodes; ++i) {
            tempInDegree[i] = inDegree[i];
            if (tempInDegree[i] != 0) continue;
            theStack.push(i);
        }
        for (i = 0; i < currentNodes; ++i) {
            wasVisited[i] = false;
        }
        i = 0;
        while (!theStack.isEmpty()) {
            i = theStack.pop();
            wasVisited[i] = true;
            topoOrder.add(new Integer(i + 1));
            for (int j = 0; j < currentNodes; ++j) {
                if (Adjacency[i][j] != 1) continue;
                int n = j;
                tempInDegree[n] = tempInDegree[n] - 1;
                if (tempInDegree[j] != 0) continue;
                theStack.push(j);
            }
        }
        result = this.graphNodesHaveBeenVisited(wasVisited, currentNodes);
        return result;
    }

    public int outGoingArcsOfNode(int[][] Adjacency, int node, int currentNodes) {
        int counter = 0;
        for (int i = 0; i < currentNodes; ++i) {
            if (Adjacency[node][i] != 1) continue;
            ++counter;
        }
        return counter;
    }

    class dialogOkButtonActionListener
    implements ActionListener {
        dialogOkButtonActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            Utils.this.dialog.setVisible(false);
        }
    }

    class dialogWindowListener
    extends WindowAdapter {
        dialogWindowListener() {
        }

        public void windowClosing(WindowEvent e) {
            Utils.this.dialog.setVisible(false);
        }
    }

    class dialogNoButtonActionListener
    implements ActionListener {
        dialogNoButtonActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            Utils.this.dialog.setVisible(false);
            Utils.this.dialogResult = false;
        }
    }

    class dialogYesButtonActionListener
    implements ActionListener {
        dialogYesButtonActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            Utils.this.dialog.setVisible(false);
            Utils.this.dialogResult = true;
        }
    }
}

